% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_xy2TKA.R
\name{convert_xy2TKA}
\alias{convert_xy2TKA}
\title{Convert xy-data to TKA}
\usage{
convert_xy2TKA(object, file = NULL, overwrite = FALSE)
}
\arguments{
\item{object}{\link{rxylib} (\strong{required}): xy data as imported by the function \link{read_xyData}. Optional
a file supported by the \code{rxylib}-package can be provided as input. Arguments can be provided as \link{list}.}

\item{file}{\link{character} (optional): optional file path or file name for the output to be written.
If only a path is provided the output file name is derived from the input file name. Argument
can be provided as \link{list}.}

\item{overwrite}{\link{logical} (with default): force overwriting of existing files if \code{TRUE}.}
}
\value{
Returns a \link{list} of \link{matrix} objects or an output TKA-file.
}
\description{
Convert data to the Toolkit file format (TKA) as exported by, e.g., by the software
Canberra Genie 2000.
}
\details{
\strong{Supported formats}
\itemize{
\item Canberra CNF
\item further formats on request ...
}
}
\section{Function version}{
 0.1.0
}

\examples{

##convert CNF data (no export to file system)
convert_xy2TKA(
 object = system.file("extdata/ExampleSpectrum.CNF", package = "rxylib"))

\dontrun{
##export as file

##create temporary filepath
##(for usage replace by own path)
temp_file <- tempfile(pattern = "output", fileext = ".TKA")

##convert and write to file system
convert_xy2TKA(
 object = system.file("extdata/ExampleSpectrum.CNF", package = "rxylib"),
 file = temp_file)

}

}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Université Bordeaux Montaigne (France)
} 

\section{How to cite}{
Kreutzer, S., 2019. convert_xy2TKA(): Convert xy-data to TKA. Function version 0.1.0. In: Kreutzer, S., Friedrich, J., 2019. rxylib: Import XY-Data into R R package version 0.2.4. https://github.com/R-Lum/rxylib
}

\keyword{IO}
