% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotACC.R
\name{PlotACC}
\alias{PlotACC}
\title{Plot Plumes/Timeseries Of Anomaly Correlation Coefficients}
\usage{
PlotACC(
  ACC,
  sdates,
  toptitle = "",
  sizetit = 1,
  ytitle = "",
  limits = NULL,
  legends = NULL,
  freq = 12,
  biglab = FALSE,
  fill = FALSE,
  linezero = FALSE,
  points = TRUE,
  vlines = NULL,
  fileout = "output_PlotACC.eps",
  width = 8,
  height = 5,
  size_units = "in",
  res = 100,
  ...
)
}
\arguments{
\item{ACC}{ACC matrix with with dimensions:\cr
c(nexp, nobs, nsdates, nltime, 4)\cr
with the fourth dimension of length 4 containing the lower limit of the 
95\% confidence interval, the ACC, the upper limit of the 95\% confidence 
interval and the 95\% significance level.}

\item{sdates}{List of startdates: c('YYYYMMDD','YYYYMMDD').}

\item{toptitle}{Main title, optional.}

\item{sizetit}{Multiplicative factor to scale title size, optional.}

\item{ytitle}{Title of Y-axis for each experiment: c('',''), optional.}

\item{limits}{c(lower limit, upper limit): limits of the Y-axis, optional.}

\item{legends}{List of flags (characters) to be written in the legend, 
optional.}

\item{freq}{1 = yearly, 12 = monthly, 4 = seasonal, ... Default: 12.}

\item{biglab}{TRUE/FALSE for presentation/paper plot, Default = FALSE.}

\item{fill}{TRUE/FALSE if filled confidence interval. Default = FALSE.}

\item{linezero}{TRUE/FALSE if a line at y=0 should be added. Default = FALSE.}

\item{points}{TRUE/FALSE if points instead of lines. Default = TRUE.\cr
Must be TRUE if only 1 leadtime.}

\item{vlines}{List of x location where to add vertical black lines, optional.}

\item{fileout}{Name of output file. Extensions allowed: eps/ps, jpeg, png, 
pdf, bmp and tiff. \cr
Default = 'output_PlotACC.eps'}

\item{width}{File width, in the units specified in the parameter size_units 
(inches by default). Takes 8 by default.}

\item{height}{File height, in the units specified in the parameter 
size_units (inches by default). Takes 5 by default.}

\item{size_units}{Units of the size of the device (file or window) to plot 
in. Inches ('in') by default. See ?Devices and the creator function of the 
corresponding device.}

\item{res}{Resolution of the device (file or window) to plot in. See 
?Devices and the creator function of the corresponding device.}

\item{\dots}{Arguments to be passed to the method. Only accepts the following
graphical parameters:\cr
adj ann ask bg bty cex.sub cin col.axis col.lab col.main col.sub cra crt 
csi cxy err family fg fig fin font font.axis font.lab font.main font.sub 
lend lheight ljoin lmitre mar mex mfcol mfrow mfg mkh oma omd omi page 
plt smo srt tck tcl usr xaxp xaxs xaxt xlog xpd yaxp yaxs yaxt ylbias ylog\cr
For more information about the parameters see `par`.}
}
\description{
Plots plumes/timeseries of ACC from an array with dimensions 
(output from \code{ACC()}): \cr
c(nexp, nobs, nsdates, nltime, 4)\cr
where the fourth dimension is of length 4 and contains the lower limit of 
the 95\% confidence interval, the ACC, the upper limit of the 95\% 
confidence interval and the 95\% significance level given by a one-sided 
T-test.
}
\examples{
# See examples on Load() to understand the first lines in this example
 \dontrun{
data_path <- system.file('sample_data', package = 's2dverification')
expA <- list(name = 'experiment', path = file.path(data_path,
            'model/$EXP_NAME$/$STORE_FREQ$_mean/$VAR_NAME$_3hourly',
            '$VAR_NAME$_$START_DATE$.nc'))
obsX <- list(name = 'observation', path = file.path(data_path,
            '$OBS_NAME$/$STORE_FREQ$_mean/$VAR_NAME$',
            '$VAR_NAME$_$YEAR$$MONTH$.nc'))

# Now we are ready to use Load().
startDates <- c('19851101', '19901101', '19951101', '20001101', '20051101')
sampleData <- Load('tos', list(expA), list(obsX), startDates,
                  leadtimemin = 1, leadtimemax = 4, output = 'lonlat',
                  latmin = 27, latmax = 48, lonmin = -12, lonmax = 40)
 }
 \dontshow{
startDates <- c('19851101', '19901101', '19951101', '20001101', '20051101')
sampleData <- s2dverification:::.LoadSampleData('tos', c('experiment'),
                                               c('observation'), startDates,
                                               leadtimemin = 1,
                                               leadtimemax = 4,
                                               output = 'lonlat',
                                               latmin = 27, latmax = 48,
                                               lonmin = -12, lonmax = 40)
 }
sampleData$mod <- Season(sampleData$mod, 4, 11, 12, 2)
sampleData$obs <- Season(sampleData$obs, 4, 11, 12, 2)
clim <- Clim(sampleData$mod, sampleData$obs)
ano_exp <- Ano(sampleData$mod, clim$clim_exp)
ano_obs <- Ano(sampleData$obs, clim$clim_obs)
acc <- ACC(Mean1Dim(sampleData$mod, 2), 
          Mean1Dim(sampleData$obs, 2))
 \donttest{
PlotACC(acc$ACC, startDates, toptitle = "Anomaly Correlation Coefficient")

 }
}
\author{
History:\cr
0.1  -  2013-08  (V. Guemas)  -  Original code\cr
1.0  -  2013-09  (N. Manubens)  -  Formatting to CRAN
}
\keyword{dynamic}
