% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_get.R
\name{s3_get}
\alias{s3_get}
\title{download s3 file}
\usage{
s3_get(
  s3_uri,
  region = "us-east-2",
  quiet = FALSE,
  progress = FALSE,
  force = FALSE,
  public = FALSE
)
}
\arguments{
\item{s3_uri}{URI for an S3 object}

\item{region}{AWS region for bucket containing the file (defaults to "us-east-2", but only required for private files)}

\item{quiet}{suppress messages?}

\item{progress}{show download progress? (currently only for public objects)}

\item{force}{force download to overwrite existing S3 object}

\item{public}{defaults to FALSE; if TRUE, ignore any environment
variables specifying AWS credentials and
attempt to download the file as publicly available}
}
\value{
a character string that is the file path to the downloaded file (invisibly)
}
\description{
Files are downloaded to the R user data directory (i.e., \code{tools::R_user_dir("s3", "data")}) so they can be cached across all of an R user's sessions and projects. Specify an alternative download location by setting the \code{R_USER_DATA_DIR} environment variable (see \code{?tools::R_user_dir}).
}
\examples{
\donttest{
the_file <- s3_get(s3_uri = "s3://geomarker/testing_downloads/mtcars.rds")
s3_get("s3://geomarker/testing_downloads/mtcars.rds") |>
    readRDS()
unlink(the_file)
}
}
