% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_system_async.R
\name{stream_async}
\alias{stream_async}
\alias{s3_file_stream_in_async}
\alias{s3_file_stream_out_async}
\title{Streams data from R to AWS S3.}
\usage{
s3_file_stream_in_async(path, ...)

s3_file_stream_out_async(
  obj,
  path,
  max_batch = fs_bytes("100MB"),
  overwrite = FALSE,
  ...
)
}
\arguments{
\item{path}{(character): A character vector of paths or s3 uri}

\item{...}{parameters to be passed to \code{\link[paws.storage]{s3_get_object}} and
\code{\link[paws.storage]{s3_put_object}}}

\item{obj}{(raw|character): A raw vector, rawConnection, url to be streamed up to AWS S3.}

\item{max_batch}{(\link[fs]{fs_bytes}): Maximum batch size being uploaded with each multipart.}

\item{overwrite}{(logical): Overwrite files if the exist. If this is \code{FALSE}
and the file exists an error will be thrown.}
}
\value{
return \code{\link[future]{future}} object of \code{\link[=s3_file_stream_in]{s3_file_stream_in()}} \code{\link[=s3_file_stream_out]{s3_file_stream_out()}}
}
\description{
\code{s3_file_stream_in} streams in AWS S3 file as a raw vector

\code{s3_file_stream_out} streams raw vector out to AWS S3 file
}
\seealso{
\code{\link[future]{future}} \code{\link[=s3_file_move]{s3_file_move()}} \code{\link[=s3_file_stream_in]{s3_file_stream_in()}} \code{\link[=s3_file_stream_out]{s3_file_stream_out()}}
}
