#' @title Sample Data for Small Area Estimation using Hierarchical Bayesian Method under Normal distribution
#'
#' @description Dataset to simulate Small Area Estimation using Hierarchical Bayesian Method under Normal distribution
#'
#' This data is generated by these following steps:
#'
#' \enumerate{
#'   \item Generate sampling random area effect \code{u} with  \code{u ~ N(0,1)}. The auxiliary variables are generated by uniform distribution with  \code{x1 ~ U(0,1)}, \code{x2 ~ U(1,5)} and \code{x3 ~ U(8,15)} . The coefficient parameters \eqn{ \beta_{0}, \beta_{1}, \beta_{2},and \beta_{3}}{\beta0, \beta1, \beta2, and \beta3} are set as 1.
#'   \cr Calculate \eqn{\mu}{\mu} = \eqn{\beta_{0}}{\beta0}+\eqn{\beta_{1}x_{1}}{\beta1x1}+\eqn{\beta_{2}x_{2}}{\beta2x2}+\eqn{\beta_{3}x_{3}}{\beta3x3} + \eqn{u}{u}
#'   \cr Generate variance of direct estimate, vardir, with \eqn{\sigma^2_{e}}{\sigma2e} ~  \code{InvGamma(a,b)}
#'   \cr Generate sampling error \code{e} with \eqn{e  ~  N(0,\sigma^2_{e})}
#'   \cr Auxiliary variables \code{x1,x2,x3}, direct estimation \code{(y)} and vardir are combined in a dataframe called \code{dataBeta}
#'   \item Calculate the direct estimate of \code{mu}, i.e \eqn{y=\mu+e}
#' }
#'
#' @format A data frame with 50 rows and 4 variables:
#' \describe{
#'   \item{y}{Direct Estimation of y}
#'   \item{x1}{Auxiliary variable of x1}
#'   \item{x2}{Auxiliary variable of x2}
#'   \item{x3}{Auxiliary variable of x3}
#'   \item{vardir}{Sampling Variance of y}
#' }
#'

"dataNormal"
