% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Normal.R
\name{Normal}
\alias{Normal}
\title{Small Area Estimation using Hierarchical Bayesian under Normal Distribution}
\usage{
Normal(
  formula,
  vardir,
  iter.update = 3,
  iter.mcmc = 10000,
  coef,
  var.coef,
  thin = 2,
  burn.in = 2000,
  tau.u = 1,
  data
)
}
\arguments{
\item{formula}{Formula that describe the fitted model}

\item{vardir}{Sampling variances of direct estimations}

\item{iter.update}{Number of updates with default \code{3}}

\item{iter.mcmc}{Number of total iterations per chain with default \code{10000}}

\item{coef}{a vector contains prior initial value of Coefficient of Regression Model for fixed effect with default vector of \code{0} with the length of the number of regression coefficients}

\item{var.coef}{a vector contains prior initial value of variance of Coefficient of Regression Model with default vector of \code{1} with the length of the number of regression coefficients}

\item{thin}{Thinning rate, must be a positive integer with default \code{2}}

\item{burn.in}{Number of iterations to discard at the beginning with default \code{2000}}

\item{tau.u}{Prior initial value of inverse of Variance of area random effect with default \code{1}}

\item{data}{The data frame}
}
\value{
This function returns a list of the following objects:
   \item{Est}{A vector with the values of Small Area mean Estimates using Hierarchical bayesian method }
   \item{refVar}{Estimated random effect variances}
   \item{coefficient}{A dataframe with the estimated model coefficient}
   \item{plot}{Trace, Dencity, Autocorrelation Function Plot of MCMC samples}
}
\description{
This function is implemented to variable of interest \eqn{(y)} that assumed to be a Normal Distribution. The range of data is \eqn{(-\infty < y < \infty)}
}
\examples{
\donttest{
#Data Generation
set.seed(123)
m=30
x1=runif(m,0,1)
x2=runif(m,1,5)
x3=runif(m,10,15)
x4=runif(m,10,20)
b0=b1=b2=b3=b4=0.5
u=rnorm(m,0,1)
vardir=1/rgamma(m,1,1)
Mu <- b0+b1*x1+b2*x2+b3*x3+b4*x4+u
y=rnorm(m,Mu,sqrt(vardir))
dataNormal=as.data.frame(cbind(y,x1,x2,x3,x4,vardir))
dataNormalNs=dataNormal
dataNormalNs$y[c(3,10,15,29,30)] <- NA
dataNormalNs$vardir[c(3,10,15,29,30)] <- NA


#Compute Fitted Model
#y ~ x1 +x2 +x3 +x4


## For data without any nonsampled area
formula=y~x1+x2+x3+x4
var= "vardir"
v = c(1,1,1,1,1)
c= c(0,0,0,0,0)


# Using parameter coef and var.coef
saeHBnormal<-Normal(formula,vardir=var,coef=c,var.coef=v,data=dataNormal)

saeHBnormal$Est                                 #Small Area mean Estimates
saeHBnormal$refVar                              #Random effect variance
saeHBnormal$coefficient                         #coefficient
#Load Library 'coda' to execute the plot
#autocorr.plot(saeHBnormal$plot[[3]]) is used to generate ACF Plot
#plot(saeHBnormal$plot[[3]]) is used to generate Density and trace plot

# Do not using parameter coef and var.coef
saeHBnormal<-Normal(formula,vardir ="vardir",data=dataNormal)



## For data with nonsampled area use dataNormalNs

}
}
