% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\docType{methods}
\name{bootstrap}
\alias{bootstrap}
\alias{boot}
\alias{boot,ANY,ANY,integerORnumeric-method}
\alias{boot,rfh,rfhVariance,NULL-method}
\title{Fit model on Bootstrap sample}
\usage{
bootstrap(object, matV = variance(object), B = NULL, ...)

boot(object, matV, B, ...)

\S4method{boot}{ANY,ANY,integerORnumeric}(object, matV, B, filter = NULL,
  postProcessing = identity, ...)

\S4method{boot}{rfh,rfhVariance,`NULL`}(object, matV, B, ...)
}
\arguments{
\item{object}{a fitted object}

\item{matV}{the variance of a fitted object used to draw samples. In most
cases this is \code{object}. Alternatively it may be useful to use a
non-robust model.}

\item{B}{the number of repetitions}

\item{...}{arguments passed down to methods}

\item{filter}{a vector indicating which elements in the fittedd object to
keep in each repetition.}

\item{postProcessing}{a function to process the results. Is applied before
the filter.}
}
\description{
These functions help to repeatedly fit a \link{rfh} model on bootstrap
samples. Use \code{bootstrap} as a user interface. \code{boot} can be used to
extend the framework but is not meant to be used interactively. If you are
interested in the parameteric bootstrap for a 'rfh' model you can use the
implementation in \link{mse}.
}
\examples{
data(milk, package = "sae")
milk$samplingVar <- milk$SD^2
modelFit <- rfh(yi ~ as.factor(MajorArea), milk, "samplingVar")
bootstrapCoefs <- bootstrap(modelFit, B = 2, filter = "coefficients")
do.call(rbind, unlist(bootstrapCoefs, FALSE))
}
