% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SaemixObject.R
\name{saemixControl}
\alias{saemixControl}
\title{List of options for running the algorithm SAEM}
\usage{
saemixControl(map = TRUE, fim = TRUE, ll.is = TRUE, ll.gq = FALSE,
  nbiter.saemix = c(300, 100), nb.chains = 1, fix.seed = TRUE,
  seed = 23456, nmc.is = 5000, nu.is = 4, print.is = FALSE,
  nbdisplay = 100, displayProgress = TRUE, nbiter.burn = 5,
  nbiter.mcmc = c(2, 2, 2), proba.mcmc = 0.4, stepsize.rw = 0.4,
  rw.init = 0.5, alpha.sa = 0.97, nnodes.gq = 12, nsd.gq = 4,
  maxim.maxiter = 100, nb.sim = 1000, nb.simpred = 100,
  ipar.lmcmc = 50, ipar.rmcmc = 0.05, print = TRUE, save = TRUE,
  save.graphs = TRUE, directory = "newdir", warnings = FALSE)
}
\arguments{
\item{map}{a boolean specifying whether to estimate the individual parameters (MAP estimates). Defaults to TRUE}

\item{fim}{a boolean specifying whether to estimate the Fisher Information Matrix and derive the estimation errors 
for the parameters. Defaults to TRUE. The linearised approximation to the log-likelihood is also computed in the process}

\item{ll.is}{a boolean specifying whether to estimate the log-likelihood by importance sampling. Defaults to TRUE}

\item{ll.gq}{a boolean specifying whether to estimate the log-likelihood by Gaussian quadrature. Defaults to FALSE}

\item{nbiter.saemix}{nb of iterations in each step (a vector containing 2
elements)}

\item{nb.chains}{nb of chains to be run in parallel in the MCMC algorithm.
Defaults to 1.}

\item{fix.seed}{TRUE (default) to use a fixed seed for the random number
generator. When FALSE, the random number generator is initialised using a
new seed, created from the current time.  Hence, different sessions started
at (sufficiently) different times will give different simulation results.
The seed is stored in the element seed of the options list.}

\item{seed}{seed for the random number generator. Defaults to 123456}

\item{nmc.is}{nb of samples used when computing the likelihood through
importance sampling}

\item{nu.is}{number of degrees of freedom of the Student distribution used
for the estimation of the log-likelihood by Importance Sampling. Defaults to
4}

\item{print.is}{when TRUE, a plot of the likelihood as a function of the
number of MCMC samples when computing the likelihood through importance
sampling is produced and updated every 500 samples. Defaults to FALSE}

\item{nbdisplay}{nb of iterations after which to display progress}

\item{displayProgress}{when TRUE, the convergence plots are plotted after
every nbdisplay iteration, and a dot is written in the terminal window to
indicate progress. When FALSE, plots are not shown and the algorithm runs
silently. Defaults to TRUE}

\item{nbiter.burn}{nb of iterations for burning}

\item{nbiter.mcmc}{nb of iterations in each kernel during the MCMC step}

\item{proba.mcmc}{probability of acceptance}

\item{stepsize.rw}{stepsize for kernels q2 and q3. Defaults to 0.4}

\item{rw.init}{initial variance parameters for kernels. Defaults to 0.5}

\item{alpha.sa}{parameter controlling cooling in the Simulated Annealing
algorithm. Defaults to 0.97}

\item{nnodes.gq}{number of nodes to use for the Gaussian quadrature when
computing the likelihood with this method (defaults to 12)}

\item{nsd.gq}{span (in SD) over which to integrate when computing the
likelihood by Gaussian quadrature. Defaults to 4 (eg 4 times the SD)}

\item{maxim.maxiter}{Maximum number of iterations to use when maximising the
fixed effects in the algorithm. Defaults to 100}

\item{nb.sim}{number of simulations to perform to produce the VPC plots or
compute npde. Defaults to 1000}

\item{nb.simpred}{number of simulations used to compute mean predictions
(ypred element), taken as a random sample within the nb.sim simulations used
for npde}

\item{ipar.lmcmc}{number of iterations required to assume convergence for
the conditional estimates. Defaults to 50}

\item{ipar.rmcmc}{confidence interval for the conditional mean and variance.
Defaults to 0.95}

\item{print}{whether the results of the fit should be printed out. Defaults
to TRUE}

\item{save}{whether the results of the fit should be saved to a file.
Defaults to TRUE}

\item{save.graphs}{whether diagnostic graphs and individual graphs should be
saved to files. Defaults to TRUE}

\item{directory}{the directory in which to save the results. Defaults to
"newdir" in the current directory}

\item{warnings}{whether warnings should be output during the fit. Defaults to FALSE}
}
\description{
List containing the variables relative to the optimisation algorithm. All
these elements are optional and will be set to default values when running
the algorithm if they are not specified by the user.
}
\details{
All the variables are optional and will be set to their default value when
running \code{\link{saemix}}.

The function \code{\link{saemix}} returns an object with an element options
containing the options used for the algorithm, with defaults set for
elements which have not been specified by the user.

These elements are used in subsequent functions and are not meant to be used
directly.
}
\examples{


# All default options
saemix.options<-saemixControl()

# All default options, changing seed
saemix.options<-saemixControl(seed=632545)


}
\references{
Comets  E, Lavenu A, Lavielle M. Parameter estimation in nonlinear mixed effect models using saemix, an R implementation of the SAEM algorithm. Journal of Statistical Software 80, 3 (2017), 1-41.

Kuhn E, Lavielle M. Maximum likelihood estimation in nonlinear mixed effects models. Computational Statistics and Data Analysis 49, 4 (2005), 1020-1038.

Comets E, Lavenu A, Lavielle M. SAEMIX, an R version of the SAEM algorithm.
20th meeting of the Population Approach Group in Europe, Athens, Greece
(2011), Abstr 2173.
}
\seealso{
\code{\link{SaemixData}},\code{\link{SaemixModel}},
\code{\link{SaemixObject}}, \code{\link{saemix}}
}
\author{
Emmanuelle Comets <emmanuelle.comets@inserm.fr>, Audrey Lavenu,
Marc Lavielle.
}
\keyword{models}
