% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safedata_network.R
\name{try_to_download}
\alias{try_to_download}
\title{Attempt to download a URL resource, failing gracefully.}
\usage{
try_to_download(url, local_path = NULL, timeout = 10)
}
\arguments{
\item{url}{The URL to download.}

\item{local_path}{A path to a file in which to save the URL content.}

\item{timeout}{The waiting time in seconds before a request should
timeout.}
}
\value{
An \code{response} object or a boolean showing if the
   download attempt was successful.
}
\description{
This function tries to fetch a resource from a URL and handles failure to
resolve the resource (bad URLs), timeouts and then actual HTTP error
codes.
}
\details{
If the download fails, the function returns FALSE and the return value
attribute 'fail_msg' is used to provide details. Otherwise, an
\code{\link[httr]{response}} object is returned containing the resource. If a
local path is provided, the resource is downloaded to that path and the
function returns TRUE to indicate success.
}
\section{Note}{


This function contains code to simulate network failures of varying kinds (no
network, no API, specific resource unavailable) for use in unit testing.
}

\keyword{internal}
