% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logRankTest.R
\name{computeLogrankZ}
\alias{computeLogrankZ}
\title{Helper function to computes the logrank statistic for 'Surv' objects of type
"right" and "counting" with the hypergeometric variance.}
\usage{
computeLogrankZ(
  survObj,
  group,
  computeZ = TRUE,
  computeExactE = FALSE,
  theta0 = 1,
  thetaS = NULL,
  ...
)
}
\arguments{
\item{survObj}{a Surv object that is either of type}

\item{group}{a grouping factor with 2 levels}

\item{computeZ}{logical. If \code{TRUE} computes the logrank z-statistic.
Default is \code{TRUE}.}

\item{computeExactE}{logical. If \code{TRUE} computes one-sided exact logrank e-value.
Default is \code{FALSE}.}

\item{theta0}{numeric > 0 used only for the e-value, i.e., if computeExactE is \code{TRUE}.
Default is 1.}

\item{thetaS}{numeric > 0 used only for the e-value, i.e., if computeExactE is \code{TRUE}.
Default is NULL.}

\item{...}{further arguments to be passed to or from methods.}
}
\value{
Returns a list containing at least the following components:
\describe{
  \item{nEvents}{the number of events.}
  \item{z}{the observed logrank statistic.}
  \item{oMinEVector}{vector of observed minus expected.}
  \item{varVector}{vector of hypergeometric variances.}
  \item{stopTimeVector}{vector at which the events occurred.}
}
}
\description{
This function was created to complement \code{\link[survival]{survdiff}} from the
'survival' package, which is restricted to 'Surv' objects of type "right". Most likely
\code{\link[survival]{survdiff}} is much faster
}
\examples{
data <- generateSurvData(nP = 5,
                         nT = 5,
                         lambdaP = 0.03943723,
                         lambdaT = 0.5*0.03943723,
                         endTime = 40,
                         seed = 2006)

survObj <- survival::Surv(data$time, data$status)

survObj <- survival::Surv(data$time, data$status)

result <- computeLogrankZ(survObj, data$group)
result$z
sqrt(survival::survdiff(survObj~data$group)$chisq)
}
