% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tTest.R
\name{defineTTestN}
\alias{defineTTestN}
\title{Computes a Sequence of (Effective) Sample Sizes}
\usage{
defineTTestN(
  lowN = 3,
  highN = 100,
  ratio = 1,
  testType = c("oneSample", "paired", "twoSample")
)
}
\arguments{
\item{lowN}{integer minimal sample size of the (first) sample when computing the power due to
optional stopping. Default lowN is set 1.}

\item{highN}{integer minimal sample size of the (first) sample when computing the power due to
optional stopping. Default highN is set 1e6.}

\item{ratio}{numeric > 0 representing the randomisation ratio of condition 2 over condition 1. If testType
is not equal to "twoSample", or if nPlan is of length(1) then ratio=1.}

\item{testType}{either one of "oneSample", "paired", "twoSample".}
}
\value{
Returns the sample sizes and degrees of freedom.
}
\description{
Helper function that outputs the sample sizes, effective sample sizes and the degrees of
freedom depending on the type of t-test. Also used for z-tests.
}
