% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setSettingsValue.R
\name{setSettingsValue}
\alias{setSettingsValue}
\title{Set the value for a given named parameter}
\usage{
setSettingsValue(key, value, settings, forceCreate = FALSE)
}
\arguments{
\item{key}{a list (like those provided by \code{getSettingKeys()}) defining the position of parameter in the settings object.}

\item{value}{the value to set}

\item{settings}{The settings list used to generate a chart like \code{eDISH()}}

\item{forceCreate}{Specifies whether the function should create a new list() when none exisits. This most commonly occurs when deeply nested objects.}
}
\value{
the updated settings object
}
\description{
Sets the value for a named parameter (\code{key}) to given \code{value} in a list (\code{settings})
}
\examples{
testSet<-list(a=list(b="myValue"))
safetyGraphics:::setSettingsValue(key=list("a","b"), value="notMyValue", settings=testSet) 
#returns list(a=list(b="notMyValue")))

adamSettings<-generateSettings(standard="AdAM")
safetyGraphics:::setSettingsValue(list("id_col"),"customID",adamSettings) 
safetyGraphics:::setSettingsValue(list("measure_values","ALP"),"Alanine Aminotrans",adamSettings)
safetyGraphics:::setSettingsValue(list("myCustomSetting"),"customized",adamSettings) 
#adds myCustomSetting to adamSettings

}
\keyword{internal}
