% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{CalculateGroupPath}
\alias{CalculateGroupPath}
\title{Calcule les trajectoires par groupe pour un diagramme en radar (Calculate Group Path)}
\source{
Code adapted from a solution posted by Tony M to \url{https://stackoverflow.com/questions/9614433/creating-radar-chart-a-k-a-star-plot-spider-plot-using-ggplot2-in-r}.
}
\usage{
CalculateGroupPath(df)
}
\arguments{
\item{df}{a dataframe with Col 1 is group ('unique' cluster / group ID of entity) and Col 2-n are  v1.value to vn.value - values (e.g. group/cluser mean or median) of variables v1 to v.n}
}
\value{
a dataframe of the calculated axis paths
}
\description{
Converts variable values into a set of radial x-y coordinates
}
\examples{
library(dplyr)
library(scales)
library(tibble)

mtcars_radar <- mtcars \%>\%
  as_tibble(rownames = "group") \%>\%
  mutate_at(vars(-group), rescale) \%>\%
  tail(4) \%>\%
  select(1:10)
plot.data <- as.data.frame(mtcars_radar)
if(!is.factor(plot.data[, 1])) {
  plot.data[, 1] <- as.factor(as.character(plot.data[, 1]))
  }
names(plot.data)[1] <- "group"
CalculateGroupPath(plot.data)
}
