% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-metadata.R
\name{sf_read_metadata}
\alias{sf_read_metadata}
\title{Read Object or Field Metadata from Salesforce}
\usage{
sf_read_metadata(metadata_type, object_names, verbose = FALSE)
}
\arguments{
\item{metadata_type}{\code{character}; string on what type of metadata to create.}

\item{object_names}{a character vector of names that we wish to read metadata for}

\item{verbose}{\code{logical}; an indicator of whether to print additional
detail for each API call, which is useful for debugging. More specifically, when
set to \code{TRUE} the URL, header, and body will be printed for each request,
along with additional diagnostic information where available.}
}
\value{
A \code{list} containing a response for each requested object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function takes a request of named elements in Salesforce and
returns their metadata
}
\examples{
\dontrun{
metadata_info <- sf_read_metadata(metadata_type='CustomObject', 
                                  object_names=c('Account'))
}
}
\references{
\url{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/}
}
