% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analytics-report.R
\name{sf_describe_report}
\alias{sf_describe_report}
\title{Describe a report}
\usage{
sf_describe_report(report_id, verbose = FALSE)
}
\arguments{
\item{report_id}{\code{character}; the Salesforce Id assigned to a created
analytics report. It will start with \code{"00O"}.}

\item{verbose}{\code{logical}; an indicator of whether to print additional
detail for each API call, which is useful for debugging. More specifically, when
set to \code{TRUE} the URL, header, and body will be printed for each request,
along with additional diagnostic information where available.}
}
\value{
\code{list} containing up to 4 properties that describe the report:
\describe{
\item{attributes}{Report type along with the URL to retrieve common objects and joined metadata.}
\item{reportMetadata}{Unique identifiers for groupings and summaries.}
\item{reportTypeMetadata}{Fields in each section of a report type plus filter information for those fields.}
\item{reportExtendedMetadata}{Additional information about summaries and groupings.}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Retrieves report, report type, and related metadata for a tabular, summary,
or matrix report.
}
\details{
\itemize{
\item Report metadata gives information about the report as a whole. Tells you such things as, the report type, format, the fields that are summaries, row or column groupings, filters saved to the report, and so on.
\item Report type metadata tells you about all the fields available in the report type, those you can filter, and by what filter criteria.
\item Report extended metadata tells you about the fields that are summaries, groupings, and contain record details in the report.
}
}
\section{Salesforce Documentation}{

\itemize{
\item \href{https://developer.salesforce.com/docs/atlas.en-us.api_analytics.meta/api_analytics/sforce_analytics_rest_api_getbasic_reportmetadata.htm}{Documentation}
\item \href{https://developer.salesforce.com/docs/atlas.en-us.api_analytics.meta/api_analytics/sforce_analytics_rest_api_get_reportmetadata.htm#example_report_getdescribe}{Example}
}
}

\examples{
\dontrun{
# pull a list of up to 200 recent reports
# (for a full list you must use sf_query on the Report object)
reports <- sf_list_reports()

# id for the first report
reports[[1,"id"]]

# describe that report type
described_report <- sf_describe_report_type(unique_report_types[[1,"id"]])
}
}
\seealso{
Other Report functions: 
\code{\link{sf_copy_report}()},
\code{\link{sf_create_report}()},
\code{\link{sf_delete_report}()},
\code{\link{sf_describe_report_type}()},
\code{\link{sf_execute_report}()},
\code{\link{sf_list_report_fields}()},
\code{\link{sf_list_report_filter_operators}()},
\code{\link{sf_list_report_types}()},
\code{\link{sf_list_reports}()},
\code{\link{sf_query_report}()},
\code{\link{sf_run_report}()},
\code{\link{sf_update_report}()}
}
\concept{Report functions}
