% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectMRHLP.R
\name{selectMRHLP}
\alias{selectMRHLP}
\title{selecMRHLP implements a model selection procedure to select an optimal MRHLP
model with unknown structure.}
\usage{
selectMRHLP(X, Y, Kmin = 1, Kmax = 10, pmin = 0, pmax = 4,
  criterion = c("BIC", "AIC"), verbose = TRUE)
}
\arguments{
\item{X}{Numeric vector of length \emph{m} representing the covariates/inputs
\eqn{x_{1},\dots,x_{m}}.}

\item{Y}{Matrix of size \eqn{(m, d)} representing a \eqn{d} dimension
function of \code{X} observed at points \eqn{1,\dots,m}. \code{Y} is the observed
response/output.}

\item{Kmin}{The minimum number of regimes (MRHLP components).}

\item{Kmax}{The maximum number of regimes (MRHLP components).}

\item{pmin}{The minimum order of the polynomial regression.}

\item{pmax}{The maximum order of the polynomial regression.}

\item{criterion}{The criterion used to select the MRHLP model ("BIC", "AIC").}

\item{verbose}{Optional. A logical value indicating whether or not a summary
of the selected model should be displayed.}
}
\value{
selectMRHLP returns an object of class \link{ModelMRHLP}
representing the selected MRHLP model according to the chosen \code{criterion}.
}
\description{
selecMRHLP implements a model selection procedure to select an optimal MRHLP
model with unknown structure.
}
\details{
selectMRHLP selects the optimal MRHLP model among a set of model
candidates by optimizing a model selection criteria, including the Bayesian
Information Criterion (BIC). This function first fits the different MRHLP
model candidates by varying the number of regimes \code{K} from \code{Kmin} to \code{Kmax}
and the order of the polynomial regression \code{p} from \code{pmin} to \code{pmax}. The
model having the highest value of the chosen selection criterion is then
selected.
}
\examples{
data(multivtoydataset)

# Let's select a MRHLP model on a multivariate time series with 3 regimes:
data <- multivtoydataset[1:320, ]
x <- data$x
y <- data[, c("y1", "y2", "y3")]

selectedmrhlp <- selectMRHLP(X = x, Y = y, Kmin = 2, Kmax = 4,
                             pmin = 0, pmax = 1)

selectedmrhlp$summary()
}
\seealso{
\link{ModelMRHLP}
}
