% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df_search.R
\name{get_eigen_spline}
\alias{get_eigen_spline}
\title{Compute eigenSplines across a dataset}
\usage{
get_eigen_spline(inputData, ind, time, nPC = NA, scaling = "scaling_UV",
  method = "nipals", verbose = TRUE, centering = TRUE, ncores = 0)
}
\arguments{
\item{inputData}{Matrix of measurements with observations as rows and variables as columns.}

\item{ind}{Vector of subject identifier (individual) corresponding to each measurement.}

\item{time}{Vector of time corresponding to each measurement.}

\item{nPC}{(int) Number of Principal Components to compute, if none given (\code{nPC=NA}) compute all PC (usually number TP-1 as there is 1PC less than the smallest dimension).}

\item{scaling}{\code{"scaling_UV"} or \code{"scaling_mean"} scaling across all samples for each variable. Default \code{"scaling_UV"}. Note: scaling takes place outside of the pcaMethods call, therefore \code{$model} will indicate "Data was NOT scaled before running PCA".}

\item{method}{PCA method \code{"svd"} doesn't accept missing value. \code{"nipals"} can handle missing values. Default \code{"nipals"}.}

\item{verbose}{If \code{TRUE} print the PCA summary. Default \code{TRUE}.}

\item{centering}{If \code{TRUE} centering for PCA, needed to remove baseline levels of each pc (often PC1). Default \code{TRUE}.}

\item{ncores}{(int) Number of cores to use for parallelisation of the grouping of all splines. Default 0 for no parallelisation.}
}
\value{
A list eigen: \code{eigen$matrix} \code{data.frame} of eigenSplines values with PCprojection as row and TIME as column. \code{eigen$variance} Vector of variance explained for each PC. \code{eigen$model} resulting pcaMethods model. \code{eigen$countTP} Matrix of number of measurements for each unique timepoint (as row).

\subsection{Comments:}{
   \itemize{
       \item CENTERING: Centering converts all the values to fluctuations around zero instead of around the mean of the variable measurements. Hereby, it adjusts for differences in the offset between high and low intensity variables. It is therefore used to focus on the fluctuating part of the data, and leaves only the relevant variation (being the variation between the observations) for analysis.
       \item SCALING: Scaling methods are data pretreatment approaches that divide each variable by a factor -the scaling factor- which is different for each variable. They aim to adjust for the differences in fold differences between the various variables by converting the data into differences in values relative to the scaling factor. This often results in the inflation of small values, which can have an undesirable side effect as the influence of the measurement error -that is usually relatively large for small values- is increased as well.
       \item UNIT VARIANCE SCALING: UV or Autoscaling, is commonly applied and uses the standard deviation as the scaling factor. After autoscaling, all variables have a standard deviation of one and therefore the data is analysed on the basis of correlations instead of covariances, as is the case with centering.
       \item BEFORE PCA, centering must be applied on the matrix that will be submitted to PCA to remove "baseline" levels.
   }
}
}
\description{
Compute "eigenSplines" across a dataset to discover the best \emph{df} for spline fitting.  
\subsection{Steps:}{
   \itemize{
       \item UV Scale the data.
       \item Turn each VAR in (IND x TIME) and group all VAR in (IND+VAR x TIME) using \code{\link{get_eigen_spline_matrix}}.
       \item Compute "eigen.splines" on the transposed table (TIME x IND+VAR).
       \item Returns eigen$matrix = PCprojection x TIME and eigen$variance = variance explained for each PC.
   }
}
}
\examples{
## 7 measurements, 3 subjects, 4 unique time-points, 2 variables
inputData <- matrix(c(1,2,3,4,5,6,7,8,9 ,10,11,12,13,14,15,16,17,18), ncol=2)
ind  <- c('ind_1','ind_1','ind_1','ind_2','ind_2','ind_2','ind_3','ind_3','ind_3')
time <- c(0,5,10,0,10,15,5,10,15)
get_eigen_spline(inputData, ind, time, nPC=NA, scaling="scaling_UV", method="nipals",
                 verbose=TRUE, centering=TRUE, ncores=0)
# nipals calculated PCA
# Importance of component(s):
#                  PC1    PC2     PC3
# R2            0.7113 0.2190 0.05261
# Cumulative R2 0.7113 0.9303 0.98287
# total time: 0.12 secs
# $matrix
#              0          5        10         15
# PC1 -1.7075707 -0.7066426 0.7075708  1.7066425
# PC2 -0.3415271  0.9669724 1.0944005 -0.4297013
# PC3 -0.1764657 -0.5129981 0.5110671  0.1987611
# 
# $variance
# [1] 0.71126702 0.21899068 0.05260949
# 
# $model
# nipals calculated PCA
# Importance of component(s):
#                  PC1    PC2     PC3
# R2            0.7113 0.2190 0.05261
# Cumulative R2 0.7113 0.9303 0.98287
# 6 	Variables
# 4 	Samples
# 6 	NAs ( 25 \%)
# 3 	Calculated component(s)
# Data was mean centered before running PCA 
# Data was NOT scaled before running PCA 
# Scores structure:
# [1] 4 3
# Loadings structure:
# [1] 6 3
# 
# $countTP
#   [,1]
# 3    6

}
\seealso{
Graphical implementation with \code{\link{santaR_start_GUI}}

Other DFsearch: \code{\link{get_eigen_DFoverlay_list}},
  \code{\link{get_eigen_DF}},
  \code{\link{get_param_evolution}},
  \code{\link{plot_nbTP_histogram}},
  \code{\link{plot_param_evolution}}
}
