% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/breaks.R, R/chop.R
\name{brk_n}
\alias{brk_n}
\alias{chop_n}
\title{Chop into fixed-sized groups}
\usage{
brk_n(n)

chop_n(x, n, ...)
}
\arguments{
\item{n}{Integer: number of elements in each interval.}

\item{x}{A numeric vector.}

\item{...}{Passed to \code{chop}.}
}
\value{
For  \verb{chop_*} functions, a factor of the same length as \code{x}.
}
\description{
\code{chop_n()} creates intervals containing a fixed number of elements. One
interval may have fewer elements.
}
\examples{
table(chop_n(1:10, 5))

table(chop_n(1:10, 4))

}
\seealso{
Other chopping functions: 
\code{\link{brk_mean_sd}()},
\code{\link{brk_quantiles}()},
\code{\link{brk_width}()},
\code{\link{chop}()},
\code{\link{fillet}()}
}
\concept{chopping functions}
