% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chop.R, R/breaks.R
\name{chop_mean_sd}
\alias{chop_mean_sd}
\alias{brk_mean_sd}
\title{Chop by standard deviations}
\usage{
chop_mean_sd(x, sd = 3, ...)

brk_mean_sd(sd = 3)
}
\arguments{
\item{x}{A vector.}

\item{sd}{Positive number: include up to \code{sd} standard deviations.}

\item{...}{Passed to \code{\link[=chop]{chop()}}.}
}
\value{
For  \verb{chop_*} functions, a factor of the same length as \code{x}.
}
\description{
Intervals of width 1 standard deviation are included on either side of the mean.
The outermost pair of intervals will be shorter if \code{sd} is not a whole number.
}
\examples{
chop_mean_sd(1:10)

chop(1:10, brk_mean_sd())

}
\seealso{
Other chopping functions: 
\code{\link{chop_n}()},
\code{\link{chop_quantiles}()},
\code{\link{chop_width}()},
\code{\link{chop}()},
\code{\link{fillet}()}
}
\concept{chopping functions}
