% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{.collapse_timestamp}
\alias{.collapse_timestamp}
\title{.collapse_timestamp helper}
\usage{
.collapse_timestamp(timestamp, ..., period, side = "start")
}
\value{
A vector of the same length as TIMESTAMP, with the collapsed timestamp
  with the same tz as the original one.
}
\description{
Util to collapse the TIMESTAMP using lubridate::*_date functions
}
\section{Period}{

Periods accepted are in the "number period" format, as in
\code{\link[lubridate]{floor_date}} or a custom function name without quotes:
\itemize{
  \item{hours (exs. "1 hour", "12 hours")}
  \item{days (exs. "1 day", "3 days")}
  \item{weeks (exs. "1 week", "4 weeks")}
  \item{months (exs. "1 month", "6 months")}
  \item{years (exs. "1 year", "7 years")}
  \item{Also a custom function can be supplied, one that transforms the
  TIMESTAMP variable to the collapsed timestamp desired. See
  \code{\link{sfn_metrics}} for details}
}
}

\section{Side}{

Side indicates if using \code{\link[lubridate]{floor_date}} (side = "start) or
\code{\link[lubridate]{ceiling_date}} (side = 'end'). Ceiling dates is not
trivial, see \code{\link[lubridate]{ceiling_date}} for information on how
the date will be ceiled.
}

\examples{
arg_tre_timestamp <- get_timestamp(ARG_TRE)
sapfluxnetr:::.collapse_timestamp(
  arg_tre_timestamp, period = "1 day", side = 'start'
)
}
\keyword{internal}
