% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plotEnrichment}
\alias{plotEnrichment}
\title{Plot concordance indices for a geneset}
\usage{
plotEnrichment(geneset, rankedGenes)
}
\arguments{
\item{geneset}{A geneset as returned by \code{\link{saps}}.}

\item{rankedGenes}{A vector of concordance index z-scores. Usually this
will be the \code{rankedGenes} element returned by \code{\link{saps}}.}
}
\description{
This function draws concordance indices for a given geneset
    relative to the concordance indices for all the genes in the dataset
    (i.e., the degree of enrichment for the geneset).
}
\examples{
# 25 patients, none lost to followup
followup <- rep(1, 25)

# first 5 patients have good survival (in days)
time <- c(25, 27, 24, 21, 26, sample(1:3, 20, TRUE))*365

# create data for 100 genes, 25 patients
dat <- matrix(rnorm(25*100), nrow=25, ncol=100)
colnames(dat) <- as.character(1:100)

# create two random genesets of 5 genes each
set1 <- sample(colnames(dat), 5)
set2 <- sample(colnames(dat), 5)

genesets <- rbind(set1, set2)

# run saps
\dontrun{
results <- saps(genesets, dat, time, followup, random.samples=100)

set <- results$genesets[["set1"]]

# p_enrich should not be significant
plotEnrichment(set, results$rankedGenes)

# increase expression levels for set1 for first 5 patients
dat[1:5, set1] <- dat[1:5, set1]+10

# run saps again
results <- saps(genesets, dat, time, followup, random.samples=100)

set <- results$genesets[["set1"]]

# now it should be significant
plotEnrichment(set, results$rankedGenes)
}
}
\seealso{
\code{\link{saps}} \code{\link{rankConcordance}}
}

