% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/warpSP.R
\name{warpSP}
\alias{warpSP}
\title{Warp one snow profile onto another one}
\usage{
warpSP(alignment, whom = NA)
}
\arguments{
\item{alignment}{DTW alignment object from \link{dtwSP} containing the two profiles (i.e., called \code{dtwSP(..., keep.internals = TRUE)})}

\item{whom}{whom to warp? "query" (= "jmin"), "imin", "queryTopDown" (= "jminTopDown"), "iminTopDown", "ref";
if 'NA' the routine determines that itself from the structure of the alignment object. (see Details)}
}
\value{
Returns the input alignment object including the element alignment$queryWarped (or $referenceWarped),
which are the warped snow profiles. The class of the alignment object is altered to "dtwSP", but still inherits "dtw".
}
\description{
After the DTW alignment of two profiles, the maps between the two profiles can be used to
warp one profile onto the other profile. In other words, the layer thicknesses of the warped profile
are adjusted to optimally align with the corresponding layers of the other profile.
}
\details{
After this procedure, the thickness of some layers can be zero, which leads to the layers disappearing.

This function is automatically called in \code{dtwSP(..., keep.internals = TRUE)} to warp the query profile
onto the reference profile.

\emph{Whom} to warp: There exist 8 different options, 4 for warping the query onto the ref and 4 for vice versa.
The 4 options for warping the query onto the ref are:
\itemize{
\item global alignment / partial alignment where entire query is matched to subsequence of ref ("jmin")
\item partial alignment where entire ref is matched to subsequence of query ("imin")
\item partial top down alignment where entire query is matched to subsequence of ref ("jminTopDown")
\item partial top down alignment where entire ref is matched to subsequence of query ("iminTopDown")
}

For the other case, warping the ref onto the query, only the equivalent of the first option is implemented.
}
\examples{

## first align profiles
alignment <- dtwSP(SPpairs$A_modeled, SPpairs$A_manual, open.end = FALSE)

## warp reference profile onto query profile:
refWarped <- warpSP(alignment, whom = "ref")$referenceWarped
opar <- par(no.readonly =TRUE)
par(mfrow = c(1, 2))
plot(alignment$query, main = "query")
plot(refWarped, main = "warped reference")
par(opar)

}
\author{
fherla
}
