% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getColoursDensity.R
\name{getColoursDensity}
\alias{getColoursDensity}
\title{Gets colours for plotting snow density values}
\usage{
getColoursDensity(Values, Resolution = 101, Verbose = FALSE)
}
\arguments{
\item{Values}{Density values (kg/m3)}

\item{Resolution}{Resolution of colour scale. Default is 100.}

\item{Verbose}{Switch for writing out value and html colour tuplets for debugging.}
}
\value{
Array with HTML colour codes
}
\description{
Gets colours for plotting snow density values in snowprofiles. Colours are consistent with niViz at https://niviz.org
}
\examples{

Density <- seq(0,700, by=10)
plot(x = rep(1,length(Density)), y = Density, col = getColoursDensity(Density), pch = 19, cex = 3)

}
\seealso{
\link{getColoursGrainSize}, \link{getColoursGrainType}, \link{getColoursHardness}, \link{getColoursLWC}, \link{getColoursSnowTemp}
}
\author{
phaegeli
}
