% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snowprofileInstabilitySigns.R
\name{snowprofileInstabilitySigns}
\alias{snowprofileInstabilitySigns}
\title{Constructor for a snowprofileInstabilitySigns object}
\usage{
snowprofileInstabilitySigns(
  signsFrame = data.frame(type = as.character(NA), present = as.character(NA), comment
    = as.character(NA)),
  dropNAs = TRUE
)
}
\arguments{
\item{signsFrame}{a data.frame listing snowpack stability signs. Rows correspond to individual observations of instability signs
and columns describe at least the fields \code{c("type", "present")}.
\itemize{
\item type: Sc, Sa, Na, whumpf, crack, ...
\item present: Was the instability sign present (TRUE), not present (FALSE), or unknown (NA), for example
\itemize{
\item natural avalanches occurred (i.e., Na TRUE), did not occur (i.e., Na FALSE), no observations were carried out (i.e., Na NA)
\item skiing the slope led to an avalanche (i.e., Sa TRUE)
\item ski cutting did not release avalanche (i.e., Sc FALSE)
\item etc
}
}}

\item{dropNAs}{Should empty, non-mandatory columns be dropped from the final snowprofileInstabilitySigns object?}
}
\value{
snowprofileInstabilitySigns object
}
\description{
Create a snowprofileInstabilitySigns object. Instability signs can for example be whumpfs, cracking, natural avalanches, skier accidental release, ski cutting, etc.
For more information, see
Canadian Avalanche Association. (2016). Observation Guidelines and Recording Standards for Weather, Snowpack, and Avalanches. Revelstoke, BC, Canada.
}
\details{
Note: This class might be a temporary solution to digitize instability signs observed in proximity to snowprofiles.
The information contained here, might be ported to a more general field observations class that is both independent from
snowprofile objects and that is more in line with existing field observation standards.
}
\examples{
## create a data.frame with instability sign observations
(signsFrame <- data.frame(type = c("Na", "whumpf", "cracking", "Sa"),
                         present = c(FALSE, TRUE, FALSE, FALSE)))

## create snowprofileInstabilitySigns object
instabilitySigns <- snowprofileInstabilitySigns(signsFrame)

## create snowprofile object containing instability signs and check resulting object:
snowprofile(instabilitySigns = instabilitySigns)

}
\seealso{
\link{snowprofile}, \link{snowprofileLayers}, \link{snowprofileTests}
}
\author{
fherla
}
