% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_collection.R
\name{fit_collection}
\alias{fit_collection}
\title{Create a Collection of SAR Model Fits}
\usage{
fit_collection(..., fits = list(...))
}
\arguments{
\item{...}{A set of one or more SAR model fits (all of class 'sars').}

\item{fits}{Internal argument that creates a list of the model fits.}
}
\value{
A list of class 'sars' with n elements, corresponding to the
  n individual SAR model fits.
}
\description{
Creates a fit collection of SAR model fits, which can then be
  plotted using \code{\link{plot.sars}}.
}
\examples{
data(galap)
fit <- sar_linear(galap)
fit2 <- sar_power(galap)
fitC <- fit_collection(fit, fit2)
plot(fitC)
}
