% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_sass.R
\name{as_sass}
\alias{as_sass}
\title{Convert an R object into Sass code}
\usage{
as_sass(input)
}
\arguments{
\item{input}{Any of the following:
\itemize{
\item A character vector containing Sass code.
\item A named list containing variable names and values.
\item A \code{\link[=sass_file]{sass_file()}}, \code{\link[=sass_layer]{sass_layer()}}, and/or \code{\link[=sass_bundle]{sass_bundle()}}.
\item A \code{\link[=list]{list()}} containing any of the above.
}}
}
\value{
a single character value to be supplied to \code{\link[=sass]{sass()}}.
}
\description{
Converts multiple types of inputs to a single Sass input string for
\code{\link[=sass]{sass()}}.
}
\examples{
# Example of regular Sass input
as_sass("body { color: \"blue\"; }")

# There is support for adding variables
as_sass(
  list(
    list(color = "blue"),
   "body { color: $color; }"
   )
)

\donttest{
# Add a file name
someFile <- tempfile("variables")

# Overwrite color to red
write("$color: \"red\";", someFile)

input <-
  as_sass(
    list(
      list(color = "blue"),
      sass_file(someFile),
      "body { color: $color; }"
      )
   )

input

# The final body color is red
sass(input)
}
}
\references{
\url{https://sass-lang.com/documentation/file.SASS_REFERENCE.html#import}
}
