% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_list_children.R
\name{item_list_children}
\alias{item_list_children}
\title{Return IDs for all child items}
\usage{
item_list_children(
  sb_id,
  fields = c("id", "title"),
  ...,
  session = current_session(),
  limit = 20
)
}
\arguments{
\item{sb_id}{An \code{\link{sbitem}} object or a character ScienceBase ID corresponding to the item}

\item{fields}{A character vector of requested data fields. Defaults to 'id' and 'title'. Full list of possible fields 
is available online in \href{https://www.usgs.gov/sciencebase-instructions-and-documentation/item-core-model}{SB documentation}.}

\item{...}{Additional parameters are passed on to \code{\link[httr]{GET}}, \code{\link[httr]{POST}},
\code{\link[httr]{HEAD}}, \code{\link[httr]{PUT}}, or \code{\link[httr]{DELETE}}}

\item{session}{Session object from \code{\link{authenticate_sb}}. Defaults to anonymous or 
last authenticated session}

\item{limit}{Max children returned.}
}
\value{
List of \code{sbitem} for each child item.
}
\description{
Returns a list of child IDs for a ScienceBase item
}
\examples{
\dontrun{
item_list_children(user_id())
}

\donttest{
item_list_children(as.sbitem('5060b03ae4b00fc20c4f3c8b'))
item_list_children(item_get('5060b03ae4b00fc20c4f3c8b'))
}
}
