% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Seurat_Plotting.R
\name{DimPlot_All_Samples}
\alias{DimPlot_All_Samples}
\title{DimPlot by Meta Data Column}
\usage{
DimPlot_All_Samples(
  seurat_object,
  meta_data_column = "orig.ident",
  colors_use = "black",
  pt.size = NULL,
  title_size = 15,
  num_columns = NULL,
  reduction = NULL,
  dims = c(1, 2),
  raster = NULL,
  raster.dpi = c(512, 512),
  ...
)
}
\arguments{
\item{seurat_object}{Seurat object name.}

\item{meta_data_column}{Meta data column to split plots by.}

\item{colors_use}{single color to use for all plots or a vector of colors equal to the number of plots.}

\item{pt.size}{Adjust point size for plotting.}

\item{title_size}{size for plot title labels.}

\item{num_columns}{number of columns in final layout plot.}

\item{reduction}{Dimensionality Reduction to use (if NULL then defaults to Object default).}

\item{dims}{Which dimensions to plot.  Defaults to c(1,2) if not specified.}

\item{raster}{Convert points to raster format.  Default is NULL which will rasterize by default if
greater than 200,000 cells.}

\item{raster.dpi}{Pixel resolution for rasterized plots, passed to geom_scattermore().
Default is c(512, 512).}

\item{...}{Extra parameters passed to \code{\link[Seurat]{DimPlot}}.}
}
\value{
A ggplot object
}
\description{
Creates DimPlot layout containing all samples within Seurat Object from orig.ident column
}
\examples{
library(Seurat)

pbmc_small$sample_id <- sample(c("sample1", "sample2"), size = ncol(pbmc_small), replace = TRUE)

DimPlot_All_Samples(seurat_object = pbmc_small, meta_data_column = "sample_id", color = "black",
num_columns = 2)

}
\concept{seurat_plotting}
