% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{Case_Check}
\alias{Case_Check}
\title{Check for alternate case features
Checks Seurat object for the presence of features with the same spelling but alternate case.}
\usage{
Case_Check(
  seurat_object,
  gene_list,
  case_check_msg = TRUE,
  return_features = TRUE,
  assay = NULL
)
}
\arguments{
\item{seurat_object}{Seurat object name.}

\item{gene_list}{vector of genes to check.}

\item{case_check_msg}{logical. Whether to print message to console if alternate case features are
found in addition to inclusion in returned list.  Default is TRUE.}

\item{return_features}{logical. Whether to return vector of alternate case features.  Default is TRUE.}

\item{assay}{Name of assay to pull feature names from. If NULL will use the result of \code{DefaultAssay(seurat_object)}.}
}
\value{
If features found returns vector of found alternate case features and prints message depending on
parameters specified.
}
\description{
Check for alternate case features
Checks Seurat object for the presence of features with the same spelling but alternate case.
}
\examples{
\dontrun{
alt_features <- Case_Check(seurat_object = obj_name, gene_list = DEG_list)
}

}
\concept{helper_util}
