% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PGN_XGBoost.R
\name{PGN_XGBoost}
\alias{PGN_XGBoost}
\title{Peak-Gene Network via XGBoost}
\usage{
PGN_XGBoost(
  X,
  Y,
  gene_data,
  neibor_peak,
  dirpath = tempdir(),
  count_device = 1,
  rebuild_PGN_XGB = TRUE,
  save_file = TRUE
)
}
\arguments{
\item{X}{The scATAC-seq data, sparse matrix.}

\item{Y}{The scRNA-seq data, sparse matrix.}

\item{gene_data}{The information for genes, must have a col names "gene_name".}

\item{neibor_peak}{The peak IDs within a certain range of each gene, must have cols c("gene_name", "start_use", "end_use"). The id numbers in "start_use" and "end_use" are start from 0.}

\item{dirpath}{The folder path to read or write file.}

\item{count_device}{The number of cpus used to train the Lasso model.}

\item{rebuild_PGN_XGB}{Logical. Whether to rebuild the peak-gene network via XGBoost from scratch. If FALSE, the function will attempt to read from \code{PGN_XGB.mtx} under \cr \code{dirpath/test} in single mode or \code{dirpath/state_name/test} in compare mode.}

\item{save_file}{Logical, whether to save the output to a file.}
}
\value{
The PGN_XGBoost network.
}
\description{
Construct the peak-gene network via XGBoost.
}
\examples{
\donttest{
library(scPOEM)
dirpath <- "./example_data"
# Download single mode example data
data(example_data_single)
# Construct PGN net via XGBoost.
net_XGB <- PGN_XGBoost(example_data_single$X,
                       example_data_single$Y,
                       example_data_single$gene_data,
                       example_data_single$neibor_peak,
                       file.path(dirpath, "single"),
                       save_file=FALSE)
}

}
