\name{relltest}
\alias{relltest}
\alias{summary.relltest}

\title{RELL Test for Phylogenetic Inference}
\description{
  Performs the RELL test for finding the largest item. This
  calculates AU p-values for each item via the multiscale bootstrap resampling.
  This is particularly useful for testing tree topologies in phylogenetic analysis.
}
\usage{

relltest(dat,nb=10000,sa=9^seq(-1,1,length=13),ass=NULL,
         cluster=NULL,nofit=FALSE,models=NULL,seed=100)

}
\arguments{
  \item{dat}{a matrix. Row vectors are to be resampled. Each column
    vector gives score values to be evaluated for an item. For the
    phylogenetic analysis, \code{dat[i,j]} is the site-wise log-likelihood value
    at site-i for tree-j, and we are to find the tree with the largest
    expected value of \code{sum(dat[,j])}.}
  \item{nb}{Number of replicates for each scale.}
  \item{sa}{Scales in sigma squared (\eqn{\sigma^2}).}
  \item{ass}{A list of association vectors for testing edges as well as
    trees. If \code{ass=NULL}, then only the results for trees are returned.}
  \item{cluster}{\pkg{parallel} cluster object which may be generated by
    function \code{makeCluster}.}
  \item{nofit}{logical. Passed to \code{\link{sbfit}}.}
  \item{models}{character vectors. Passed to \code{\link{sbfit}}.}
  \item{seed}{If non NULL, then a random seed is set. Specifying a seed is
    particularly important when \code{cluster} is non NULL, in this
    case \code{seed + seq(along=cluster)} are set to cluster nodes.}
}
\details{
  \code{relltest} performs the resampling of estimated log-likelihoods
  (RELL) method of Kishino et al. (1990). For resampling indices stored
  in a vector \code{i}, the resampled log-likelihood for a tree-j is
  approximately calculated by \code{sum(dat[i,j])}. This approximation
  avoids time-consuming recalculation of the maximum likelihood
  estimates of tree parameters, which are to be calculated by an
  external phylogenetic software such as PAML as described in
  \code{\link{mam15}}. In the implementation of \code{relltest}, the
  resampled log-likelihood is calculated by
  \code{sum(dat[i,j])}\code{*nrow(dat)/length(i)} so that the statistic is
  comparable to the case when \eqn{n'=n}.

  \code{relltest} first calls \code{\link{scaleboot}} internally for
  multiscale bootstrap resampling, and then \code{\link{scaleboot}}
  calls \code{\link{sbfit}} for fitting models to the bootstrap
  probabilities. The AU p-values (named "k.3") produced
  by the \code{summary} method are improvements
  of the third-order p-values calculated by CONSEL software (Shimodaira
  and Hasegawa 2001).  In addition,
  \code{relltest} calls \code{\link{scaleboot}} with \code{sa=1} for
  calculating p-values via the Shimodaira-Hasegawa test (SH-test) of
  Shimodaira and Hasegawa (1999).

  See \code{\link{mam15}} for details through an example.
}
\value{
  \code{relltest} returns an object of class \code{"relltest"} that is
  inherited from the class
  \code{"scalebootv"} by adding two extra components called "stat"
  and "shtest". "stat" is a vector of the test statistics from the
  SH-test (i.e., the log-likelihood differences), and
  "shtest" is a list with two components: "pv", a vector of SH-test
  p-values, and "pe", a vector of standard errors of the
  p-values.  The results of multiscale bootstrap resampling are stored
  in the \code{"scalebootv"} components returned by a call to
  \code{\link{sbfit}}.
}
\references{
  Kishino, H., Miyata, T. and Hasegawa, M. (1990). Maximum likelihood
  inference of  protein phylogeny and the origin of
  chloroplasts.,  \emph{J. Mol. Evol.}, 30, 151-160.

  Shimodaira, H. and Hasegawa, M. (1999). Multiple comparisons of
  log-likelihoods with applications to phylogenetic inference,
  \emph{Molecular Biology and Evolution}, 16, 1114-1116.

  Shimodaira, H. and Hasegawa, M. (2001). CONSEL: for assessing the
  confidence of phylogenetic tree selection, \emph{Bioinformatics}, 17,
  1246-1247 (software is available from
  \url{http://stat.sys.i.kyoto-u.ac.jp/prog/consel/}).

  Luke Tierney, A. J. Rossini, Na Li and H. Sevcikova. snow: Simple
  Network of Workstations. R package version 0.2-1.
}
\author{Hidetoshi Shimodaira}
\seealso{\code{\link{sbfit}}, \code{\link{scaleboot}}, \code{\link{mam15}}.}
\examples{

\dontrun{
## a quick example
data(mam15) # loading mam15.mt
mam15.trees <- relltest(mam15.mt,nb=1000) # nb=10000 is default
mam15.trees # SH-test p-values and result of fitting
summary(mam15.trees) # AU p-values
}

\dontrun{
## An example from data(mam15).
## It may take 20 mins to run relltest below.
mam15.mt <- read.mt("mam15.mt") # site-wise log-likelihoods
mam15.trees <- relltest(mam15.mt) # resampling and fitting
summary(mam15.trees) # AU p-values
}

}
\keyword{ nonparametric }

