% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tauUSC.R
\name{tauUSC}
\alias{tauUSC}
\title{Tau-U for single-case data}
\usage{
tauUSC(data, dvar, pvar, ties.method = "omit", method = "complete",
  phases = c(1, 2))
}
\arguments{
\item{data}{A single-case data frame. See \code{\link{scdf}} to learn about this format.}

\item{dvar}{Character string with the name of the dependent variable. Defaults to the attributes in the scdf file.}

\item{pvar}{Character string with the name of the phase variable. Defaults to the attributes in the scdf file.}

\item{ties.method}{Defines how to handle ties. \code{"omit"} (default) excludes all
ties from the calculation. \code{"positive"} counts all ties as positive
comparisons, while \code{"negative"} counts them as negative comparisons.}

\item{method}{\code{"complete"} (default) or \code{"parker"}. The latter 
calculates the number of possible pairs as described in Parler et al. (2011) 
which might lead to tau-U values greater than 1.}

\item{phases}{A vector of two characters or numbers indicating the two
phases that should be compared. E.g., \code{phases = c("A","C")} or
\code{phases = c(2,4)} for comparing the second to the fourth phase. Phases
could be combined by providing a list with two elements. E.g., \code{phases
= list(A = c(1,3), B = c(2,4))} will compare phases 1 and 3 (as A) against 2
and 4 (as B). Default is \code{phases = c("A","B")}.}
}
\value{
\item{table}{A data frame containing statistics from the Tau-U
family, including: Pairs, positive and negative comparisons, S, and Tau}
\item{matrix}{The matrix of comparisons used for calculating the
statistics.} \item{tau_u}{Tau-U value.}
}
\description{
This function calculates indices of the Tau-U family as proposed by Parker
et al. (2011).
}
\examples{

## Calculate tau-U for the example from Parker et al. (2011)
bob <- scdf(c(2, 3, 5, 3, 4, 5, 5, 7, 6), B.start = 5)
tauUSC(bob)

## Calculate tau-U with ties counted as positive
tauUSC(Grosche2011$Eva, ties.method = "positive")

## Request tau-U for all single-cases fom the Grosche2011 data
tauUSC(Grosche2011)

}
\references{
Parker, R. I., Vannest, K. J., Davis, J. L., & Sauber, S. B.
(2011). Combining Nonoverlap and Trend for Single-Case Research: Tau-U.
\emph{Behavior Therapy, 42}, 284-299.
}
\seealso{
Other overlap functions: \code{\link{corrected_tauSC}},
  \code{\link{nap}}, \code{\link{overlapSC}},
  \code{\link{pand}}, \code{\link{pem}}, \code{\link{pet}},
  \code{\link{pnd}}
}
\author{
Juergen Wilbert
}
\concept{overlap functions}
