% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shift.R
\name{shift}
\alias{shift}
\title{Shift values in a single-case data file}
\usage{
shift(data, value, var)
}
\arguments{
\item{data}{A single-case data frame. See \code{\link{scdf}} to learn about
this format.}

\item{value}{Number by which to shift the values}

\item{var}{Character string with the name of the target variable.
Defaults to the measurement time variable.}
}
\value{
A scdf with shifted data
}
\description{
Shifting the values might be helpful in cases where the measurement time
is given as a time variable (see example below).
}
\examples{
### Shift the measurement time for a better estimation of the intercept
ex <- shift(example_A24, value = -1996)
plm(ex)
}
\seealso{
Other data manipulation functions: 
\code{\link{as.data.frame.scdf}()},
\code{\link{fill_missing}()},
\code{\link{outlier}()},
\code{\link{ranks}()},
\code{\link{smooth_cases}()},
\code{\link{standardize}()},
\code{\link{truncate_phase}()}
}
\concept{data manipulation functions}
