% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pem.R
\name{pem}
\alias{pem}
\title{Percent exceeding the median}
\usage{
pem(
  data,
  dvar,
  pvar,
  decreasing = FALSE,
  binom.test = TRUE,
  chi.test = FALSE,
  FUN = median,
  phases = c(1, 2),
  ...
)
}
\arguments{
\item{data}{A single-case data frame. See \code{\link[=scdf]{scdf()}} to learn about this
format.}

\item{dvar}{Character string with the name of the dependent variable.
Defaults to the attributes in the scdf file.}

\item{pvar}{Character string with the name of the phase variable. Defaults to
the attributes in the scdf file.}

\item{decreasing}{If you expect data to be lower in the B phase, set
\code{decreasing = TRUE}. Default is \code{decreasing = FALSE}.}

\item{binom.test}{Computes a binomial test for a 50/50 distribution. Default
is \code{binom.test = TRUE}.}

\item{chi.test}{Computes a Chi-square test. The default setting
\code{chi.test = FALSE} skips the Chi-square test.}

\item{FUN}{Data points are compared with the phase A median. Use this
argument to implement alternative measures of central tendency. Default is
\code{FUN = median}}

\item{phases}{A vector of two characters or numbers indicating the two phases
that should be compared. E.g., \code{phases = c("A","C")} or \code{phases = c(2,4)}
for comparing the second to the fourth phase. Phases could be combined by
providing a list with two elements. E.g., \code{phases = list(A = c(1,3), B = c(2,4))} will compare phases 1 and 3 (as A) against 2 and 4 (as B). Default
is \code{phases = c(1,2)}.}

\item{\dots}{Additional arguments for the \code{FUN} parameter (e.g.
\code{FUN = mean, trim = 0.1} will use the 10 percent trimmed arithmetic
mean instead of the median for comparisons). The function must take a vector
of numeric values and the \code{na.rm} argument and return a numeric value.}
}
\description{
The \code{pem} function returns the percentage of phase B data exceeding the
phase A median.  Additionally, a chi square test against a 50/50
distribution is computed.  Different measures of central tendency can be
addressed for alternative analyses.
}
\examples{

## Calculate the PEM including the Binomial and Chi-square tests for a single-case
dat <- random_scdf(5, level = 0.5)
pem(dat, chi.test = TRUE)

}
\seealso{
Other overlap functions: 
\code{\link{cdc}()},
\code{\link{nap}()},
\code{\link{overlap}()},
\code{\link{pand}()},
\code{\link{pet}()},
\code{\link{pnd}()},
\code{\link{tau_u}()}
}
\author{
Juergen Wilbert
}
\concept{overlap functions}
