% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan_zip.R
\name{calc_zipstat_over_duration}
\alias{calc_zipstat_over_duration}
\title{Calculate the ZIP window statistic over all durations, for a given zone.}
\usage{
calc_zipstat_over_duration(table, maxdur, ...)
}
\arguments{
\item{table}{A \code{data.table} with columns \code{duration, location, p, 
mu, count}.}

\item{maxdur}{An integer; the maximum duration considered.}

\item{...}{Arguments passed to \code{\link{window_zip_statistic}}.}
}
\value{
A list with two elements:
\describe{
  \item{duration}{Vector of integers from 1 to \code{maxdur}.}
  \item{statistic}{Numeric vector containing the ZIP statistics corresponding
  to each duration, for the given spatial zone.}
}
}
\description{
This function calculates the zero-inflated Poisson statistic for a given 
spatial zone, for all durations considered.
}
\keyword{internal}

