% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scanstatistics_general.R
\name{top_clusters}
\alias{top_clusters}
\title{Get the top (non-overlappig) clusters.}
\usage{
top_clusters(x, k = 5, overlapping = FALSE)
}
\arguments{
\item{x}{An object of class scanstatistics.}

\item{k}{An integer, the number of clusters to return}

\item{overlapping}{Logical; should the top clusters be allowed to overlap in
the spatial dimension? The default is \code{FALSE}.}
}
\value{
A \code{data.table} with at most \eqn{k} rows, with columns 
   \code{zone, duration, statistic}.
}
\description{
Get the top \eqn{k} space-time clusters according to the statistic calculated
for each cluster (the maximum being the scan statistic). The default is to 
return the spatially non-overlapping clusters, i.e. those that do not have 
any locations in common.
}
\examples{
set.seed(1)
table <- scanstatistics:::create_table(list(location = 1:4, duration = 1:4), 
                                        keys = c("location", "duration"))
table[, mu := 3 * location]
table[, count := rpois(.N, mu)]
table[location \%in\% c(1, 4) & duration < 3, count := rpois(.N, 2 * mu)]
zones <- scanstatistics:::powerset_zones(4)
result <- scan_poisson(table, zones, 0)
top_clusters(result, k = 4, overlapping = FALSE)
}

