% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fss_utility_functions.R
\name{prioritize_cols}
\alias{prioritize_cols}
\title{Order row contents by priority for each timepoint.}
\usage{
prioritize_cols(priority_matrix)
}
\arguments{
\item{priority_matrix}{A numeric or integer matrix. Rows represent time (ordered from 
most recent to most distant), columns represent e.g. locations or data
streams (numbered from 1 and up). The element in row \eqn{i} and column
 \eqn{j} holds the priority of the \eqn{j}th location/data stream for 
 times \eqn{1,\ldots,i}.}
}
\value{
A matrix of the same size as the input. On each row, column indices
   are given in order of priority.
}
\description{
Given a matrix of priority function values, return a matrix in which each 
row gives the column indices of the corresponding row in the priority matrix,
when that row has been sorted from highest to lowest priority value.
}
\keyword{internal}
