% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scf_load.R
\name{scf_load}
\alias{scf_load}
\title{Load SCF Data as Multiply-Imputed Survey Designs}
\usage{
scf_load(min_year, max_year = min_year, data_directory = ".")
}
\arguments{
\item{min_year}{Integer. First SCF year to load (1989–2022, divisible by 3).}

\item{max_year}{Integer. Last SCF year to load. Defaults to \code{min_year}.}

\item{data_directory}{Character. Directory containing \code{.rds} files or a
full path to a single \code{.rds} file. Defaults to the current working directory \code{"."}.
For examples and tests, use \code{tempdir()} to avoid leaving files behind.}
}
\value{
Invisibly returns a \code{scf_mi_survey} (or named list if multiple years).
Attributes: \code{mock} (logical), \code{year}, \code{n_households}.

Invisibly returns a \code{scf_mi_survey} (or named list if multiple years).
Attributes: \code{mock} (logical), \code{year}, \code{n_households}.
}
\description{
Converts SCF \code{.rds} files prepared by \code{scf_download()} into \code{scf_mi_survey}
objects. Each object wraps five implicates per year in replicate-weighted,
multiply-imputed survey designs suitable for use with \code{scf_} functions.

Converts SCF \code{.rds} files prepared by \code{scf_download()} into \code{scf_mi_survey}
objects. Each object wraps five implicates per year in replicate-weighted,
multiply-imputed survey designs suitable for use with \code{scf_} functions.
}
\section{Implementation}{

Provide a year or range and either (1) a directory containing \verb{scf<year>.rds}
files, or (2) a full path to a single \code{.rds} file. Files must contain five
implicate data frames with columns \code{wgt} and \code{wt1b1..wt1bK} (typically K=999).


Provide a year or range and either (1) a directory containing \verb{scf<year>.rds}
files, or (2) a full path to a single \code{.rds} file. Files must contain five
implicate data frames with columns \code{wgt} and \code{wt1b1..wt1bK} (typically K=999).
}

\examples{
# Using with CRAN-compliant mock data:
# Use functions `scf_download()` and `scf_load()`
td  <- tempdir()
src <- system.file("extdata", "scf2022_mock_raw.rds", package = "scf")
file.copy(src, file.path(td, "scf2022.rds"), overwrite = TRUE)
scf2022 <- scf_load(2022, data_directory = td)

# Do not implement these lines in real analysis: Cleanup for package check
unlink("scf2022.rds", force = TRUE)

}
\seealso{
\code{\link[=scf_download]{scf_download()}}, \code{\link[=scf_design]{scf_design()}}, \code{\link[=scf_update]{scf_update()}}, \code{\link[survey:svrepdesign]{survey::svrepdesign()}}

Load SCF Data as Multiply-Imputed Survey Designs

\code{\link[=scf_download]{scf_download()}}, \code{\link[=scf_design]{scf_design()}}, \code{\link[=scf_update]{scf_update()}}, \code{\link[survey:svrepdesign]{survey::svrepdesign()}}
}
