% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sclr_fit.R
\name{sclr_fit}
\alias{sclr_fit}
\title{Fitter function for the scaled logit model}
\usage{
sclr_fit(
  y,
  x,
  tol = 10^(-7),
  algorithm = c("newton-raphson", "gradient-ascent"),
  nr_iter = 2000,
  ga_iter = 2000,
  n_conv = 3,
  conventional_names = FALSE,
  seed = NULL
)
}
\arguments{
\item{y}{A vector of observations.}

\item{x}{A design matrix.}

\item{tol}{Tolerance.}

\item{algorithm}{Algorithms to run. "newton-raphson" or "gradient-ascent".
If a character vector, the algorithms will be applied in the order they
are present in the vector.}

\item{nr_iter}{Maximum allowed iterations for Newton-Raphson.}

\item{ga_iter}{Maximum allowed iterations for gradient ascent.}

\item{n_conv}{Number of times the algorithm has to converge (to work around
local maxima).}

\item{conventional_names}{If \code{TRUE}, estimated parameter names will be
(Baseline), (Intercept) and the column names in the model matrix. Otherwise
- lambda, beta_0 and beta_ prefix in front of column names in the model
matrix.}

\item{seed}{Seed for the algorithms.}
}
\description{
Computing engine behind \code{\link{sclr}}.
}
\details{
The likelihood maximisation can use the Newton-Raphson or the gradient
ascent algprithms.
}
