% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/post_hoc.R
\name{adjustFinner}
\alias{adjustFinner}
\title{Finner correction of p-values}
\usage{
adjustFinner(pvalues)
}
\arguments{
\item{pvalues}{Raw p-values in either a vector or a matrix. Note that in case the p-values are in a matrix, all the values are used for the correction. Therefore, if the matrix contains repeated values (as those output by some methods in this package), the repetitions have to be removed.}
}
\value{
A vector or matrix with the corrected p-values
}
\description{
This function takes the particular list of possible hypthesis to correct for multiple testing, as defined in Finner (1993)
}
\details{
The test has been implemented according to the version in Garcia \emph{et al.} (2010), page 2680-2682.
}
\examples{
data(data_gh_2008)
raw.pvalues <- friedmanPost(data.gh.2008)
raw.pvalues
adjustFinner (raw.pvalues)
}
\references{
S. Garcia, A. Fernandez, J. Luengo and F. Herrera (2010) Advanced nonparametric tests for multiple comparison in the design of experiments in computational intelligence and data mining: Experimental analysis of power. \emph{Information Sciences}, 180, 2044-2064.

H. Finner (1993) On a monotocity problem in ste-down mulitple test procedures. \emph{Journal of the American Statistical Association}, 88, 920-923.
}

