% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_filter.R
\name{var_filter}
\alias{var_filter}
\title{Variable Filter}
\usage{
var_filter(dt, y, x = NULL, iv_limit = 0.02, missing_limit = 0.95,
  identical_limit = 0.95, var_rm = NULL, var_kp = NULL,
  var_rm_reason = FALSE, positive = "bad|1", ...)
}
\arguments{
\item{dt}{A data frame with both x (predictor/feature) and y (response/label) variables.}

\item{y}{Name of y variable.}

\item{x}{Name of x variables. Defaults to NULL. If x is NULL, then all columns except y are counted as x variables.}

\item{iv_limit}{The information value of kept variables should >= iv_limit. The Defaults to 0.02.}

\item{missing_limit}{The missing rate of kept variables should <= missing_limit. The Defaults to 0.95.}

\item{identical_limit}{The identical value rate (excluding NAs) of kept variables should <= identical_limit. The Defaults to 0.95.}

\item{var_rm}{Name of force removed variables, Defaults to NULL.}

\item{var_kp}{Name of force kept variables, Defaults to NULL.}

\item{var_rm_reason}{Logical, Defaults to FALSE.}

\item{positive}{Value of positive class, Defaults to "bad|1".}

\item{...}{Additional parameters.}
}
\value{
A data frame with columns for y and selected x variables, and a data frame with columns for remove reason if var_rm_reason is TRUE.
}
\description{
This function filter variables base on specified conditions, such as information value, missing rate, identical value rate.
}
\examples{
# Load German credit data
data(germancredit)

# variable filter
dt_sel = var_filter(germancredit, y = "creditability")
dim(dt_sel)

# return the reason of varaible removed
dt_sel2 = var_filter(germancredit, y = "creditability", var_rm_reason = TRUE)
lapply(dt_sel2, dim)

str(dt_sel2$dt)
str(dt_sel2$rm)

# keep columns manually, such as rowid
germancredit$rowid = row.names(germancredit)
dt_sel3 = var_filter(germancredit, y = "creditability", var_kp = 'rowid')

# remove columns manually
dt_sel4 = var_filter(germancredit, y = "creditability", var_rm = 'rowid')

}
