% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vMF.R
\name{vMF}
\alias{vMF}
\title{Score Matching Estimator for the von-Mises Fisher Distribution}
\usage{
vMF(Y, paramvec = NULL, method = "Mardia", w = rep(1, nrow(Y)))
}
\arguments{
\item{Y}{A matrix of multivariate observations in Cartesian coordinates. Each row is a multivariate measurement (i.e. each row corresponds to an individual).}

\item{paramvec}{\code{smfull} method only: Optional. A vector of same length as the dimension, representing the elements of the \eqn{\kappa \mu} vector.}

\item{method}{Either "Mardia" or "hybrid" for the hybrid score matching estimator from \insertCite{mardia2016sc;textual}{scorematchingad}
or "smfull" for the full score matching estimator.}

\item{w}{An optional vector of weights for each measurement in \code{Y}}
}
\value{
A list of \code{est}, \code{SE} and \code{info}.
\itemize{
\item \code{est} contains the estimates in vector form, \code{paramvec}, and with user friendly names \code{k} and \code{m}.
\item \code{SE} contains estimates of the standard errors if computed. See \code{\link[=cppad_closed]{cppad_closed()}}.
\item \code{info} contains a variety of information about the model fitting procedure and results.
}
}
\description{
In general the normalising constant in von Mises Fisher distributions is hard to compute, so \insertCite{mardia2016sc;textual}{scorematchingad} suggested a hybrid method that uses maximum likelihood to estimate the mean direction and score matching for the concentration.
We can also estimate all parameters using score matching (\code{smfull} method), although this estimator is likely to be less efficient than the hybrid estimator.
On the circle the hybrid estimators were often nearly as efficient as maximum likelihood estimators \insertCite{mardia2016sc}{scorematchingad}.
For maximum likelihood estimators of the von Mises Fisher distribution, which all use approximations of the normalising constant, consider \code{\link[movMF:movMF]{movMF::movMF()}}.
}
\details{
The full score matching estimator (\code{method = "smfull"}) estimates \eqn{\kappa \mu}.
The hybrid estimator (\code{method = "Mardia"}) estimates \eqn{\kappa} and \eqn{\mu} separately.
Both use \code{\link[=cppad_closed]{cppad_closed()}} for score matching estimation.
}
\section{von Mises Fisher Model}{

The von Mises Fisher density is proportional to
\deqn{\exp(\kappa \mu^T z),}
where \eqn{z} is on a unit sphere,
\eqn{\kappa} is termed the \emph{concentration},
and \eqn{\mu} is the \emph{mean direction unit vector}.
The effect of the \eqn{\mu} and \eqn{\kappa} can be decoupled in a sense \insertCite{@p169, @mardia2000di}{scorematchingad}, allowing for estimating \eqn{\mu} and \eqn{\kappa} separately.
}

\examples{
if (requireNamespace("movMF")){
  Y <- movMF::rmovMF(1000, 100 * c(1, 1) / sqrt(2))
  movMF::movMF(Y, 1) #maximum likelihood estimate
} else {
  Y <- matrix(rnorm(1000 * 2, sd = 0.01), ncol = 2)
  Y <- Y / sqrt(rowSums(Y^2))
}
vMF(Y, method = "smfull")
vMF(Y, method = "Mardia")
vMF(Y, method = "hybrid")
}
\references{
\insertAllCited{}
}
\seealso{
Other directional model estimators: 
\code{\link{Bingham}()},
\code{\link{FB}()},
\code{\link{vMF_robust}()}
}
\concept{directional model estimators}
