% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{interval_coverage}
\alias{interval_coverage}
\title{Plot Interval Coverage}
\usage{
interval_coverage(
  summarised_scores,
  colour = "model",
  facet_formula = NULL,
  facet_wrap_or_grid = "facet_wrap",
  scales = "free_y"
)
}
\arguments{
\item{summarised_scores}{Summarised scores as produced by
\code{\link{eval_forecasts}}. Make sure that "range" is included in
\code{summarise_by} when producing the summarised scores}

\item{colour}{According to which variable shall the graphs be coloured?
Default is "model".}

\item{facet_formula}{formula for facetting in ggplot. If this is \code{NULL}
(the default), no facetting will take place}

\item{facet_wrap_or_grid}{Use ggplot2's \code{facet_wrap} or
\code{facet_grid}? Anything other than "facet_wrap" will be interpreted as
\code{facet_grid}. This only takes effect if \code{facet_formula} is not
\code{NULL}}

\item{scales}{scales argument that gets passed down to ggplot. Only necessary
if you make use of facetting. Default is "free_y"}
}
\value{
ggplot object with a plot of interval coverage
}
\description{
Plot interval coverage
}
\examples{
example1 <- scoringutils::quantile_example_data_long
scores <- scoringutils::eval_forecasts(example1,
                                       summarise_by = c("model", "range"))
interval_coverage(scores)
}
