% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bias.R
\name{quantile_bias}
\alias{quantile_bias}
\title{Determines Bias of Quantile Forecasts}
\usage{
quantile_bias(range, lower, upper, true_value)
}
\arguments{
\item{range}{vector of corresponding size with information about the width
of the central prediction interval}

\item{lower}{vector of length corresponding to the number of central
prediction intervals that holds predictions for the lower bounds of a
prediction interval}

\item{upper}{vector of length corresponding to the number of central
prediction intervals that holds predictions for the upper bounds of a
prediction interval}

\item{true_value}{a single true value}
}
\value{
scalar with the quantile bias for a single quantile prediction
}
\description{
Determines bias from quantile forecasts. For an increasing number of
quantiles this measure converges against the sample based bias version
for integer and continuous forecasts.
}
\details{
For quantile forecasts, bias is measured as

\deqn{
B_t = (1 - 2 \cdot \max \{i | q_{t,i} \in Q_t \land q_{t,i} \leq x_t\}) 1( x_t \leq q_{t, 0.5}) \\
+ (1 - 2 \cdot \min \{i | q_{t,i} \in Q_t \land q_{t,i} \geq x_t\}) 1( x_t \geq q_{t, 0.5}),}

where \eqn{Q_t} is the set of quantiles that form the predictive
distribution at time \eqn{t}. They represent our
belief about what the true value $x_t$ will be. For consistency, we define
\eqn{Q_t} such that it always includes the element
\eqn{q_{t, 0} = - \infty$ and $q_{t,1} = \infty}.
\eqn{1()} is the indicator function that is \eqn{1} if the
condition is satisfied and $0$ otherwise. In clearer terms, \eqn{B_t} is
defined as the maximum percentile rank for which the corresponding quantile
is still below the true value, if the true value is smaller than the
median of the predictive distribution. If the true value is above the
median of the predictive distribution, then $B_t$ is the minimum percentile
rank for which the corresponding quantile is still larger than the true
value. If the true value is exactly the median, both terms cancel out and
\eqn{B_t} is zero. For a large enough number of quantiles, the
percentile rank will equal the proportion of predictive samples below the
observed true value, and this metric coincides with the one for
continuous forecasts.

Bias can assume values between
-1 and 1 and is 0 ideally.
}
\examples{

lower <- c(6341.000, 6329.500, 6087.014, 5703.500,
           5451.000, 5340.500, 4821.996, 4709.000,
           4341.500, 4006.250, 1127.000, 705.500)

upper <- c(6341.000, 6352.500, 6594.986, 6978.500,
           7231.000, 7341.500, 7860.004, 7973.000,
           8340.500, 8675.750, 11555.000, 11976.500)

range <- c(0, 10, 20, 30, 40, 50, 60, 70, 80, 90, 95, 98)

true_value <- 8062

quantile_bias(lower = lower, upper = upper,
              range = range, true_value = true_value)

}
\author{
Nikos Bosse \email{nikosbosse@gmail.com}
}
