% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_scores.R
\name{add_coverage}
\alias{add_coverage}
\title{Add coverage of central prediction intervals}
\usage{
add_coverage(scores, by, ranges = c(50, 90))
}
\arguments{
\item{scores}{A data.table of scores as produced by \code{\link[=score]{score()}}.}

\item{by}{character vector with column names to add the coverage for.}

\item{ranges}{numeric vector of the ranges of the central prediction intervals
for which coverage values shall be added.}
}
\value{
a data.table with unsummarised scores with columns added for the
coverage of the central prediction intervals. While the overall data.table
is still unsummarised, note that for the coverage columns some level of
summary is present according to the value specified in \code{by}.
}
\description{
Adds a column with the coverage of central prediction intervals
to unsummarised scores as produced by \code{\link[=score]{score()}}
}
\details{
The coverage values that are added are computed according to the values
specified in \code{by}. If, for example, \code{by = "model"}, then there will be one
coverage value for every model and \code{\link[=add_coverage]{add_coverage()}} will compute the coverage
for every model across the values present in all other columns which define
the unit of a single forecast.
}
\examples{
library(magrittr) # pipe operator
score(example_quantile) \%>\%
  add_coverage(by = c("model", "target_type")) \%>\%
  summarise_scores(by = c("model", "target_type")) \%>\%
  summarise_scores(fun = signif, digits = 2)
}
\keyword{scoring}
