% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_interval_coverage}
\alias{plot_interval_coverage}
\title{Plot Interval Coverage}
\usage{
plot_interval_coverage(scores, colour = "model")
}
\arguments{
\item{scores}{A data.frame of scores based on quantile forecasts as
produced by \code{\link[=score]{score()}} or \code{\link[=summarise_scores]{summarise_scores()}}. Note that "range" must be included
in the \code{by} argument when running \code{\link[=summarise_scores]{summarise_scores()}}}

\item{colour}{According to which variable shall the graphs be coloured?
Default is "model".}
}
\value{
ggplot object with a plot of interval coverage
}
\description{
Plot interval coverage
}
\examples{
\dontshow{
  data.table::setDTthreads(2) # restricts number of cores used on CRAN
}
scores <- score(example_quantile)
scores <- summarise_scores(scores, by = c("model", "range"))
plot_interval_coverage(scores)
}
