% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scphaser.R
\name{call_gt}
\alias{call_gt}
\title{Call transcribed genotypes}
\usage{
call_gt(acset, min_acount = 3, fc = 3)
}
\arguments{
\item{acset}{An acset list created by the function \code{\link{new_acset}}.
The acset must contain a refcount and altcount matrix with allele counts.}

\item{min_acount}{An integer specifying the minimum number of reads required
to be present for at least one of the two alleles as to make a call. If not
fulfilled the call is set to NA.}

\item{fc}{An integer specifying the fold-change cutoff between the expression
of the alternative and reference allele (fc.observed = alternative allele
count / reference allele count). The transcribed genotype call is set to 0 if
fc.observed <= fc, 2 if fc.observed >= fc and 1 otherwise (if there are
enough reads present, see the "min_acount" parameter).}
}
\value{
acset An acset list where the "gt" element is set or updated. "gt" is
a matrix with integer values representing transcribed genotype calls. 0:
reference allele most highly expressed, 1: bi-allelic expression with similar
degree of expression from the two alleles, 2: alternative allele most highly
expressed. NA's are used to represent entries where no call could be made.
The rownames are set to the variant column, "var", of featdata. The colnames
are set to the colnames of "refcount". The elements
[['args']][['filter']][c('min_acount', 'fc')] are added or updated to the
acset as to record the filter arguments used.
}
\description{
\code{call_gt} calls transcribed genotypes using allele RNA-seq read counts
}
\details{
This is a simplistic transcribed genotype caller which is used to discretize
which allele is the most expressed. For each variant and cell one of four
possible discrete values is set depending on the expression of the two
alleles. 0: reference allele most highly expressed, 1: bi-allelic expression
with similar degree of expression from the two alleles, 2: alternative allele
most highly expressed, or, NA if there are not enough reads to make a call.
}
\examples{
##load dataset
invisible(marinov)
acset = new_acset(featdata = marinov[['featdata']], refcount =
marinov[['refcount']], altcount = marinov[['altcount']], phenodata =
marinov[['phenodata']])

##Call transcribed genotypes
min_acount = 3
fc = 3
acset = call_gt(acset, min_acount, fc)

}

