% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scphaser.R
\name{filter_homovars}
\alias{filter_homovars}
\title{Filter homozygous variants}
\usage{
filter_homovars(acset, alpha = 0.1, mono_ase = 0.1)
}
\arguments{
\item{acset}{An acset list which must contain "refcount" and "altcount"
elements with allele counts, see \code{\link{new_acset}}.}

\item{alpha}{A numeric specifying the significance level of the binomial
test, where the test compares the number of cells expressing each allele
in an imbalanced "monoallelic" manner.}

\item{mono_ase}{A numeric between 0 and 1 specifying the allele specific
expression level at which to deem an allele monoallelically expressed.}
}
\value{
acset An acset list subsetted on variants that pass the filter.
}
\description{
\code{filter_homovars} removes variants for which a large proportion of cells
with imbalanced expression is imbalanced towards the same allele
}
\details{
The function removes variants which tend to express the same allele in a
large proportion of cells, that is, the allelic expression is stable across
cells rather than random with respect to which allele is the most highly
expressed. The purpose of this filter is to reduce the number of variants
that have falsely been called as heterozygous variants but are actually
homozygous. Use with caution as a heterozygous variants can indeed have
imbalanced expression towards the same allele in the majority of cells.
A cell is deemed to have imbalanced allelic expression if its allele-specific
expression, ase, is < mono_ase or >(1 - mono_ase), where ase = alternative
allele count / (alternative allele count + reference allele count). If the
number of cells expressing one allele in such an imbalanced manner is
significantly greater than the number of cells expressing the other allele
the variant is removed (binomial test).
}
\examples{
##load dataset
invisible(marinov)
acset = new_acset(featdata = marinov[['featdata']], refcount =
marinov[['refcount']], altcount = marinov[['altcount']], phenodata =
marinov[['phenodata']])

##Remove variants having monoallelic expression of the same allele in a
##large proportion of cells
alpha = 0.1
mono_ase = 0.1
acset_filt = filter_homovars(acset, alpha, mono_ase)

}

