% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decimal-places.R
\name{decimal_places_df}
\alias{decimal_places_df}
\title{Count decimal places in a data frame}
\usage{
decimal_places_df(
  data,
  cols = everything(),
  check_numeric_like = TRUE,
  sep = "\\\\."
)
}
\arguments{
\item{data}{Data frame.}

\item{cols}{Select columns from \code{data} using
\href{https://tidyselect.r-lib.org/reference/language.html}{tidyselect}.
Default is \code{everything()}, but restricted by \code{check_numeric_like}.}

\item{check_numeric_like}{Boolean. If \code{TRUE} (the default), the function only
operates on numeric columns and other columns coercible to numeric, as
determined by \code{is_numeric_like()}.}

\item{sep}{Substring that separates the mantissa from the integer part.
Default is \code{"\\\\."}, which renders a decimal point.}
}
\value{
Data frame. The values of the selected columns are replaced by the
numbers of their decimal places.
}
\description{
For every value in a column, \code{decimal_places_df()} counts its decimal places.
By default, it operates on all columns that are coercible to numeric.
}
\examples{
# Coerce all columns to string:
iris <- iris \%>\%
  tibble::as_tibble() \%>\%
  dplyr::mutate(across(everything(), as.character))

# The function will operate on all
# numeric-like columns but not on `"Species"`:
iris \%>\%
  decimal_places_df()

# Operate on some select columns only
# (from among the numeric-like columns):
iris \%>\%
  decimal_places_df(cols = starts_with("Sepal"))
}
\seealso{
Wrapped functions: \code{decimal_places()}, \code{dplyr::across()}.
}
