% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grim-map-total-n.R
\name{grim_map_total_n}
\alias{grim_map_total_n}
\title{GRIM-testing with hypothetical group sizes}
\usage{
grim_map_total_n(
  data,
  x1 = NULL,
  x2 = NULL,
  dispersion = 0:5,
  n_min = 1L,
  n_max = NULL,
  constant = NULL,
  constant_index = NULL,
  ...
)
}
\arguments{
\item{data}{Data frame with string columns \code{x1} and \code{x2}, and numeric column
\code{n}. The first two are group mean or percentage values with unknown group
sizes, and \code{n} is the total sample size. It is not very important whether a
value is in \code{x1} or in \code{x2} because, after the first round of tests, the
function switches roles between \code{x1} and \code{x2}, and reports the outcomes
both ways.}

\item{x1, x2}{Optionally, specify these arguments as column names in \code{data}.}

\item{dispersion}{Numeric. Steps up and down from half the \code{n} values.
Default is \code{0:5}, i.e., half \code{n} itself followed by five steps up and down.}

\item{n_min}{Numeric. Minimal group size. Default is 1.}

\item{n_max}{Numeric. Maximal group size. Default is \code{NULL}, i.e., no
maximum.}

\item{constant}{Optionally, add a length-2 vector or a list of length-2
vectors (such as a data frame with exactly two rows) to accompany the pairs
of dispersed values. Default is \code{NULL}, i.e., no constant values.}

\item{constant_index}{Integer (length 1). Index of \code{constant} or the first
\code{constant} column in the output tibble. If \code{NULL} (the default), \code{constant}
will go to the right of \code{n_change}.}

\item{...}{Arguments passed down to \code{grim_map()}.}
}
\value{
A tibble with these columns:
\itemize{
\item \code{x}, the group-wise reported input statistic, is repeated in row pairs.
\item \code{n} is dispersed from half the input \code{n}, with \code{n_change} tracking the
differences.
\item \code{both_consistent} flags scenarios where both reported \code{x} values are
consistent with the hypothetical \code{n} values.
\item \code{case} corresponds to the row numbers of the input data frame.
\item \code{dir} is \code{"forth"} in the first half of rows and \code{"back"} in the second
half. \code{"forth"} means that \code{x2} from the input is paired with the larger
dispersed \code{n}, whereas \code{"back"} means that \code{x1} is paired with the larger
dispersed \code{n}.
\item Other columns from \code{grim_map()} are preserved.
}
}
\description{
When reporting group means, some published studies only report
the total sample size but no group sizes corresponding to each mean.
However, group sizes are crucial for GRIM-testing.

In the two-groups case, \code{grim_map_total_n()} helps in these ways:
\itemize{
\item It creates hypothetical group sizes. With an even total sample size, it
incrementally moves up and down from half the total sample size. For example,
with a total sample size of 40, it starts at 20, goes on to 19 and 21, then
to 18 and 22, etc. With odd sample sizes, it starts from the two integers
around half.
\item It GRIM-tests all of these values together with the group means.
\item It reports all the scenarios in which both "dispersed" hypothetical group
sizes are GRIM-consistent with the group means.
}

All of this works with one or more total sample sizes at a time. Call
\code{audit_total_n()} for summary statistics.
}
\section{Summaries with \code{audit_total_n()}}{
 You can call
\code{audit_total_n()} following up on \code{grim_map_total_n()}
to get a tibble with summary statistics. It will have these columns:
\itemize{
\item \code{x1}, \code{x2}, and \code{n} are the original inputs.
\item \code{hits_total} is the number of scenarios in which both
\code{x1} and \code{x2} are GRIM-consistent. It is the sum
of \code{hits_forth} and \code{hits_back} below.
\item \code{hits_forth} is the number of both-consistent cases that result
from pairing \code{x2} with the larger dispersed \code{n} value.
\item \code{hits_back} is the same, except \code{x1} is
paired with the larger dispersed \code{n} value.
\item \code{scenarios_total} is the total number of test scenarios,
whether or not both \code{x1} and \code{x2}
are GRIM-consistent.
\item \code{hit_rate} is the ratio of \code{hits_total} to \code{scenarios_total}.
}

Call \code{audit()} following \code{audit_total_n()} to summarize results
even further.
}

\examples{
# Run `grim_map_total_n()` on data like these:
df <- tibble::tribble(
  ~x1,    ~x2,   ~n,
  "3.43", "5.28", 90,
  "2.97", "4.42", 103
)
df

grim_map_total_n(df)

# `audit_total_n()` summaries can be more important than
# the detailed results themselves.
# The `hits_total` column shows all scenarios in
# which both divergent `n` values are GRIM-consistent
# with the `x*` values when paired with them both ways:
df \%>\%
  grim_map_total_n() \%>\%
  audit_total_n()

# By default (`dispersion = 0:5`), the function goes
# five steps up and down from `n`. If this sequence
# gets longer, the number of hits tends to increase:
df \%>\%
  grim_map_total_n(dispersion = 0:10) \%>\%
  audit_total_n()
}
\references{
Bauer, P. J., & Francis, G. (2021). Expression of Concern: Is It
Light or Dark? Recalling Moral Behavior Changes Perception of Brightness.
\emph{Psychological Science}, 32(12), 2042–2043.
https://journals.sagepub.com/doi/10.1177/09567976211058727

Brown, N. J. L., & Heathers, J. A. J. (2017). The GRIM Test: A Simple
Technique Detects Numerous Anomalies in the Reporting of Results in
Psychology. \emph{Social Psychological and Personality Science}, 8(4), 363–369.
https://journals.sagepub.com/doi/10.1177/1948550616673876
}
\seealso{
\code{function_map_total_n()}, which created the present function using
\code{grim_map()}.
}
